/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.shoulder.core.converter.BaseLocalDateTimeConverter;
import org.springframework.lang.NonNull;

public class LocalDateConverter
extends BaseLocalDateTimeConverter<LocalDate> {
    @Override
    protected Map<String, String> initTimeParserMap() {
        LinkedHashMap<String, String> formatMap = new LinkedHashMap<String, String>(2);
        formatMap.put("yyyy-MM-dd", "^\\d{4}-\\d{1,2}-\\d{1,2}$");
        formatMap.put("yyyy/MM/dd", "^\\d{4}/\\d{1,2}/\\d{1,2}$");
        return formatMap;
    }

    @Override
    protected String toStandFormat(@NonNull String sourceDateString) {
        return super.toStandYearMonthDay(sourceDateString);
    }

    @Override
    protected BiFunction<String, DateTimeFormatter, LocalDate> parseFunction() {
        return LocalDate::parse;
    }
}

