/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.shoulder.core.converter.BaseLocalDateTimeConverter;
import org.springframework.lang.NonNull;

public class LocalDateTimeConverter
extends BaseLocalDateTimeConverter<LocalDateTime> {
    @Override
    protected Map<String, String> initTimeParserMap() {
        LinkedHashMap<String, String> formatMap = new LinkedHashMap<String, String>(2);
        formatMap.put("yyyy-MM-dd HH:mm:ss", "^\\d{4}-\\d{1,2}-\\d{1,2} {1}\\d{2}:\\d{2}:\\d{2}$");
        formatMap.put("yyyy/MM/dd HH:mm:ss", "^\\d{4}/\\d{1,2}/\\d{1,2} {1}\\d{2}:\\d{2}:\\d{2}$");
        return formatMap;
    }

    @Override
    protected String toStandFormat(@NonNull String sourceDateString) {
        if (sourceDateString.length() == 19) {
            return sourceDateString;
        }
        String[] dateTimeParts = sourceDateString.split(" ");
        String date = dateTimeParts[0];
        String time = dateTimeParts[1];
        return super.toStandYearMonthDay(date) + " " + time;
    }

    @Override
    protected BiFunction<String, DateTimeFormatter, LocalDateTime> parseFunction() {
        return LocalDateTime::parse;
    }
}

