/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.converter;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import org.shoulder.core.converter.BaseDateConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;

public class LocalTimeConverter
extends BaseDateConverter<LocalTime>
implements Converter<String, LocalTime> {
    @Override
    protected Map<String, String> initTimeParserMap() {
        return Collections.singletonMap("HH:mm:ss", "^\\d{1,2}:\\d{2}:\\d{2}$");
    }

    @Override
    protected LocalTime parseDateOrTime(@NonNull String sourceDateString, String dateTimeTemplate) {
        return LocalTime.parse(sourceDateString, DateTimeFormatter.ofPattern(dateTimeTemplate));
    }
}

