/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.delay;

import java.time.Duration;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.NonNull;

public class DelayTask
implements Delayed {
    private final long time;
    private final Runnable task;
    private final String threadPoolName;

    private DelayTask(Runnable task, long nanoTimeOut, String threadPoolName) {
        this.time = System.nanoTime() + nanoTimeOut;
        this.task = task;
        this.threadPoolName = threadPoolName;
    }

    public DelayTask(Runnable task, long time, TimeUnit unit) {
        this(task, TimeUnit.NANOSECONDS.convert(time, unit), (String)null);
    }

    public DelayTask(Runnable task, long time, TimeUnit unit, String threadPoolName) {
        this(task, TimeUnit.NANOSECONDS.convert(time, unit), threadPoolName);
    }

    public DelayTask(Runnable task, Duration daleyTime) {
        this(task, daleyTime.toNanos(), (String)null);
    }

    public DelayTask(Runnable task, Duration daleyTime, String threadPoolName) {
        this(task, daleyTime.toNanos(), threadPoolName);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.time - System.nanoTime(), TimeUnit.NANOSECONDS);
    }

    public String getThreadPoolName() {
        return this.threadPoolName;
    }

    @Override
    public int compareTo(@NonNull Delayed delayed) {
        DelayTask other = (DelayTask)delayed;
        long diff = this.time - other.time;
        if (diff > 0L) {
            return 1;
        }
        if (diff < 0L) {
            return -1;
        }
        return 0;
    }

    public Runnable getTask() {
        return this.task;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.task == null ? 0 : this.task.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        DelayTask other = (DelayTask)o;
        return this.hashCode() == other.hashCode();
    }
}

