/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.delay;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.shoulder.core.delay.DelayTask;
import org.shoulder.core.delay.DelayTaskHolder;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;

public class DelayTaskDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(DelayTaskDispatcher.class);
    private static volatile boolean running = false;
    private Executor defaultExecutor;
    private DelayTaskHolder delayTaskHolder;

    public DelayTaskDispatcher(Executor defaultExecutor, DelayTaskHolder delayTaskHolder) {
        this.defaultExecutor = defaultExecutor;
        this.delayTaskHolder = delayTaskHolder;
    }

    public synchronized void start() {
        if (running) {
            log.debug("invalid operation, already running.");
            return;
        }
        running = true;
        Thread dispatcherThread = Executors.defaultThreadFactory().newThread(this);
        dispatcherThread.setDaemon(true);
        dispatcherThread.setName("shoulderDelayTaskPorter");
        dispatcherThread.start();
    }

    @Override
    public void run() {
        log.info("DelayTaskPorter started.");
        while (true) {
            try {
                while (true) {
                    DelayTask delay;
                    Runnable task;
                    if ((task = (delay = this.delayTaskHolder.next()).getTask()) == null) {
                        continue;
                    }
                    this.defaultExecutor.execute(task);
                }
            }
            catch (Exception e) {
                log.error("dispatch delayTask fail", e);
                continue;
            }
            break;
        }
    }
}

