/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@ApiModel(value="\u5206\u9875\u67e5\u8be2 DTO param")
public class PageQuery
implements Serializable {
    @ApiModelProperty(value="", dataType="int", example="1")
    private int pageNo = 1;
    @ApiModelProperty(value="", dataType="int", example="20")
    private int pageSize = 20;
    @ApiModelProperty(value="", dataType="String", example="xxx")
    private String sortBy;
    @ApiModelProperty(value="", dataType="String", example="asc")
    private String order = "asc";

    public PageQuery() {
    }

    public PageQuery(Map map) {
        if (map == null) {
            return;
        }
        this.pageNo = Integer.parseInt(((Object)map.getOrDefault("pageNo", 1)).toString());
        this.pageSize = Integer.parseInt(((Object)map.getOrDefault("pageSize", 20)).toString());
        this.sortBy = map.getOrDefault("sortBy", "");
        this.order = map.getOrDefault("order", "");
        map.remove("pageNo");
        map.remove("pageSize");
        map.remove("sortBy");
        map.remove("order");
    }

    public PageQuery(int pageNo, int pageSize) {
        this(pageNo, pageSize, "", "");
    }

    public PageQuery(int pageNo, int pageSize, String sortBy, String order) {
        this.pageNo = pageNo;
        this.pageSize = pageSize;
        this.sortBy = sortBy;
        this.order = order;
    }

    public static PageQuery fromRequest() {
        HttpServletRequest servletRequest = null;
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes instanceof ServletRequestAttributes) {
            servletRequest = ((ServletRequestAttributes)requestAttributes).getRequest();
            return PageQuery.fromRequest(servletRequest);
        }
        return null;
    }

    public static PageQuery fromRequest(HttpServletRequest request) {
        PageQuery result = new PageQuery();
        String pageNo = request.getParameter("pageNo");
        String pageSize = request.getParameter("pageSize");
        result.pageNo = StringUtils.isEmpty((Object)pageNo) ? 1 : Integer.parseInt(pageNo);
        result.pageSize = StringUtils.isEmpty((Object)pageSize) ? 20 : Integer.parseInt(pageSize);
        result.sortBy = request.getParameter("sortBy");
        result.order = request.getParameter("order");
        return result;
    }

    public int getPageNo() {
        if (this.pageNo <= 0) {
            this.pageNo = 1;
        }
        return this.pageNo;
    }

    public void setPageNo(int pageNo) {
        this.pageNo = pageNo;
    }

    public int getPageSize() {
        if (this.pageSize > 1000) {
            this.pageSize = 1000;
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = sortBy;
    }

    public String getOrder() {
        return this.order;
    }
}

