/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.dto.response;

import com.github.pagehelper.PageInfo;
import io.swagger.annotations.ApiModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.shoulder.core.dto.response.ListResult;

@ApiModel(value="\u5206\u9875\u6570\u636e\u8fd4\u56de\u683c\u5f0f")
public class PageResult<T>
extends ListResult<T>
implements Serializable {
    private int pageNum;
    private int pageSize;
    private int size;
    private int totalPageNum;
    private boolean firstPage = false;
    private boolean lastPage = false;
    private boolean hasPreviousPage = false;
    private boolean hasNextPage = false;

    public static <T> PageResult<T> empty(int pageSize) {
        PageResult<T> pageResult = new PageResult<T>();
        pageResult.firstPage = true;
        pageResult.lastPage = true;
        pageResult.totalPageNum = 0;
        pageResult.size = 0;
        pageResult.pageNum = 1;
        pageResult.pageSize = pageSize;
        return pageResult;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    public void setPageNum(int pageNum) {
        this.pageNum = pageNum;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getTotalPageNum() {
        return this.totalPageNum;
    }

    public void setTotalPageNum(int totalPageNum) {
        this.totalPageNum = totalPageNum;
    }

    public boolean isFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(boolean firstPage) {
        this.firstPage = firstPage;
    }

    public boolean isLastPage() {
        return this.lastPage;
    }

    public void setLastPage(boolean lastPage) {
        this.lastPage = lastPage;
    }

    public boolean isHasPreviousPage() {
        return this.hasPreviousPage;
    }

    public void setHasPreviousPage(boolean hasPreviousPage) {
        this.hasPreviousPage = hasPreviousPage;
    }

    public boolean isHasNextPage() {
        return this.hasNextPage;
    }

    public void setHasNextPage(boolean hasNextPage) {
        this.hasNextPage = hasNextPage;
    }

    public static PageResultBuilder builder() {
        return new PageResultBuilder();
    }

    public static class PageInfoConverter {
        public static <T> PageResult<T> toResult(PageInfo<T> pageInfo) {
            if (pageInfo == null) {
                return null;
            }
            PageResult pageResult = new PageResult();
            pageResult.setFirstPage(pageInfo.isIsFirstPage());
            pageResult.setLastPage(pageInfo.isIsLastPage());
            pageResult.setTotalPageNum(pageInfo.getPages());
            pageResult.setTotal((int)pageInfo.getTotal());
            List list = pageInfo.getList();
            if (list != null) {
                pageResult.setList(new ArrayList(list));
            }
            pageResult.setPageNum(pageInfo.getPageNum());
            pageResult.setPageSize(pageInfo.getPageSize());
            pageResult.setSize(pageInfo.getSize());
            pageResult.setHasPreviousPage(pageInfo.isHasPreviousPage());
            pageResult.setHasNextPage(pageInfo.isHasNextPage());
            return pageResult;
        }
    }

    public static final class PageResultBuilder {
        boolean firstPage = false;
        private int pageNum;
        private int pageSize;
        private int size;
        private int totalPageNum;
        private int total = 0;
        private boolean lastPage = false;
        private boolean hasPreviousPage = false;
        private List list;
        private boolean hasNextPage = false;

        private PageResultBuilder() {
        }

        public static PageResultBuilder create() {
            return new PageResultBuilder();
        }

        public PageResultBuilder pageNum(int pageNum) {
            this.pageNum = pageNum;
            return this;
        }

        public PageResultBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public PageResultBuilder size(int size) {
            this.size = size;
            return this;
        }

        public PageResultBuilder totalPageNum(int totalPageNum) {
            this.totalPageNum = totalPageNum;
            return this;
        }

        public PageResultBuilder total(int total) {
            this.total = total;
            return this;
        }

        public PageResultBuilder firstPage(boolean firstPage) {
            this.firstPage = firstPage;
            return this;
        }

        public PageResultBuilder lastPage(boolean lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        public PageResultBuilder hasPreviousPage(boolean hasPreviousPage) {
            this.hasPreviousPage = hasPreviousPage;
            return this;
        }

        public PageResultBuilder list(List list) {
            this.list = list;
            return this;
        }

        public PageResultBuilder hasNextPage(boolean hasNextPage) {
            this.hasNextPage = hasNextPage;
            return this;
        }

        public <T> PageResult<T> build() {
            PageResult pageResult = new PageResult();
            pageResult.setPageNum(this.pageNum);
            pageResult.setPageSize(this.pageSize);
            pageResult.setSize(this.size);
            pageResult.setTotalPageNum(this.totalPageNum);
            pageResult.setTotal(this.total);
            pageResult.setFirstPage(this.firstPage);
            pageResult.setLastPage(this.lastPage);
            pageResult.setHasPreviousPage(this.hasPreviousPage);
            pageResult.setList(this.list);
            pageResult.setHasNextPage(this.hasNextPage);
            return pageResult;
        }
    }
}

