/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.dto.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.shoulder.core.exception.BaseRuntimeException;
import org.shoulder.core.exception.CommonErrorCodeEnum;
import org.shoulder.core.exception.ErrorCode;
import org.shoulder.core.util.ExceptionUtil;

@ApiModel(value="Restful \u98ce\u683c\u54cd\u5e94 DTO \u683c\u5f0f")
public class RestResult<T>
implements Serializable {
    @ApiModelProperty(value="\u72b6\u6001\u7801/\u9519\u8bef\u7801\uff0c\u6210\u529f\u4e3a0\uff0c\u5931\u8d25\u975e0\uff0c\u5fc5\u5b9a\u8fd4\u56de", dataType="String", required=true, example="0", position=0)
    private String code = "0";
    @ApiModelProperty(value="\u54cd\u5e94\u63cf\u8ff0\uff0c\u6210\u529f\u65f6\u4e00\u822c\u4e0d\u9700\u8981\u8be5\u503c\uff0c\u5fc5\u5b9a\u8fd4\u56de", dataType="String", required=false, example="success", position=1)
    private String msg = "success";
    @ApiModelProperty(value="\u4f20\u8f93\u7684\u6570\u636e", dataType="Object", required=false, example="{\"name\":\"shoulder\"}", position=2)
    private T data;
    private Map<String, Object> ext = Collections.emptyMap();

    public RestResult() {
    }

    public RestResult(ErrorCode errorCode) {
        this.setCode(errorCode.getCode());
        this.setMsg(errorCode.getMessage());
    }

    public RestResult<T> addExt(String key, Object value) {
        if (this.ext == Collections.EMPTY_MAP) {
            this.ext = new HashMap<String, Object>(4);
        }
        this.ext.put(key, value);
        return this;
    }

    public RestResult(String code, String msg, T data) {
        this.setCode(code);
        this.setMsg(msg);
        this.setData(data);
    }

    public static <T> RestResult<T> success() {
        return new RestResult<T>(ErrorCode.SUCCESS);
    }

    public static <T> RestResult<T> success(T data) {
        return new RestResult<T>(ErrorCode.SUCCESS).setData(data);
    }

    public static <T> RestResult<T> error(ErrorCode errorCode) {
        return new RestResult<T>(errorCode);
    }

    public static <T> RestResult<T> error(ErrorCode error, T data) {
        return new RestResult<T>(error).setData(data);
    }

    @JsonIgnore
    public T getOrException() {
        if (ErrorCode.SUCCESS.getCode().equals(this.code)) {
            return this.data;
        }
        throw new BaseRuntimeException((ErrorCode)CommonErrorCodeEnum.RPC_COMMON, this.code);
    }

    public void checkCode() {
        if (!ErrorCode.SUCCESS.getCode().equals(this.code)) {
            throw new BaseRuntimeException(this.code, this.msg);
        }
    }

    public String getCode() {
        return this.code;
    }

    public RestResult<T> setCode(String code) {
        this.code = ExceptionUtil.formatErrorCode(code);
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public RestResult<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public RestResult<T> setData(T data) {
        this.data = data;
        return this;
    }
}

