/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.exception;

import org.shoulder.core.exception.ErrorCode;
import org.slf4j.event.Level;
import org.springframework.http.HttpStatus;

public class BaseRuntimeException
extends RuntimeException
implements ErrorCode {
    private String code;
    private Level logLevel = DEFAULT_LOG_LEVEL;
    private HttpStatus httpStatus = DEFAULT_HTTP_STATUS_CODE;
    private Object[] args;

    public BaseRuntimeException(Throwable cause) {
        super(cause);
        if (cause instanceof ErrorCode) {
            ErrorCode errorCode = (ErrorCode)((Object)cause);
            this.setHttpStatus(errorCode.getHttpStatusCode());
            this.setLogLevel(errorCode.getLogLevel());
            this.setCode(errorCode.getCode());
            this.setArgs(errorCode.getArgs());
        }
    }

    public BaseRuntimeException(String message) {
        super(message);
    }

    public BaseRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public BaseRuntimeException(ErrorCode error) {
        this(error.getCode(), error.getMessage());
        this.setLogLevel(error.getLogLevel());
        this.setHttpStatus(error.getHttpStatusCode());
    }

    public BaseRuntimeException(ErrorCode error, Object ... args) {
        this(error.getCode(), error.getMessage(), args);
        this.setLogLevel(error.getLogLevel());
        this.setHttpStatus(error.getHttpStatusCode());
    }

    public BaseRuntimeException(ErrorCode error, Throwable t, Object ... args) {
        this(error.getCode(), error.getMessage(), t, args);
        this.setLogLevel(error.getLogLevel());
        this.setHttpStatus(error.getHttpStatusCode());
    }

    public BaseRuntimeException(String code, String message) {
        this(code, message, new Object[]{null});
    }

    public BaseRuntimeException(String code, String message, Throwable cause, Object ... args) {
        super(message, cause);
        this.code = code;
        this.setArgs(args);
    }

    public BaseRuntimeException(String code, String message, Object ... args) {
        super(message);
        this.code = code;
        this.setArgs(args);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    protected void setCode(String code) {
        this.code = code;
    }

    @Override
    public Object[] getArgs() {
        return this.args == null ? null : (Object[])this.args.clone();
    }

    @Override
    public void setArgs(Object ... args) {
        this.args = args == null ? null : (Object[])args.clone();
    }

    @Override
    public String getMessage() {
        return super.getMessage();
    }

    @Override
    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public void setHttpStatus(HttpStatus httpStatus) {
        this.httpStatus = httpStatus;
    }
}

