/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.exception;

import org.shoulder.core.exception.BaseRuntimeException;
import org.shoulder.core.exception.ErrorCode;
import org.slf4j.event.Level;
import org.springframework.http.HttpStatus;

public enum CommonErrorCodeEnum implements ErrorCode
{
    AUTH_401_NEED_AUTH(1L, "Need Authentication.", Level.INFO, HttpStatus.UNAUTHORIZED),
    AUTH_401_UNAUTHORIZED(2L, "Authentication failed.", Level.INFO, HttpStatus.UNAUTHORIZED),
    AUTH_401_EXPIRED(3L, "Certification expired. Re-auth please.", Level.INFO, HttpStatus.UNAUTHORIZED),
    AUTH_403_FORBIDDEN(8L, "Permission deny.", Level.INFO, HttpStatus.FORBIDDEN),
    AUTH_403_TOKEN_INVALID(9L, "Invalid token.", Level.INFO, HttpStatus.FORBIDDEN),
    FILE_CREATE_FAIL(100L, "Failed to create the file.", Level.ERROR),
    FILE_READ_FAIL(101L, "Failed to write the file.", Level.ERROR),
    FILE_WRITE_FAIL(102L, "Failed to write the file.", Level.ERROR),
    FILE_DELETE_FAIL(103L, "Failed to delete the file.", Level.ERROR),
    RPC_UNKNOWN(200L, "RPC error with none error code or msg.", Level.ERROR),
    REQUEST_TIMEOUT(201L, "Request timeout."),
    REQUEST_METHOD_MISMATCH(202L, "The request method can't be processed by the server.", Level.ERROR),
    RPC_COMMON(203L, "RPC error with error code '%s'."),
    REQUEST_BODY_INCORRECT(204L, "Entity format not supported\u3002", Level.ERROR),
    UNKNOWN(300L, "Unknown error."),
    SERVICE_RESPONSE_TIMEOUT(301L, "Service response timeout.", HttpStatus.REQUEST_TIMEOUT),
    SERVICE_UNAVAILABLE(302L, "Service unavailable.", Level.ERROR, HttpStatus.SERVICE_UNAVAILABLE),
    DEPRECATED_NOT_SUPPORT(305L, "Function not support any more.", Level.ERROR, HttpStatus.BAD_REQUEST),
    PARAM_NOT_VALID(314L, "Parameter not valid. for %s", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_BLANK(315L, "The required parameter %s is blank.", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_OUT_RANGE(316L, "The value of parameter %s is not in the right range.", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_FORMAT_INVALID(317L, "The format of parameter %s is not correct.", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_PAGE_SETTING_INVALID(318L, "Return message is too long, please resize page and retry.", HttpStatus.BAD_REQUEST),
    PARAM_NOT_SUPPORT(319L, "The parameter(%s) not supported.", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_CONTENT_TOO_LONG(310L, "The parameter(%s) content is out of limit.", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_BODY_NOT_READABLE(321L, "HttpMessageNotReadable. %s", Level.INFO, HttpStatus.BAD_REQUEST),
    PARAM_TYPE_NOT_MATCH(322L, "MethodArgumentTypeMismatch. The value of %s(%s) resolved to %s fail.", Level.INFO, HttpStatus.BAD_REQUEST),
    CONTENT_TYPE_INVALID(323L, "HttpMediaTypeNotSupported. ContentType(%s) is not acceptable.", Level.INFO, HttpStatus.BAD_REQUEST),
    MULTIPART_INVALID(324L, "Request is not a validate multipart request, please check request or file size.", HttpStatus.BAD_REQUEST),
    SIGN_INVALID(303L, "Security session invalid.", Level.INFO, HttpStatus.BAD_REQUEST),
    MID_WARE_CONNECT_FAIL(400L, "Connect ", Level.ERROR),
    PERSISTENCE_TO_DB_FAIL(401L, "Persistent fail!", Level.ERROR);

    private String code;
    private String message;
    private Level logLevel;
    private HttpStatus httpStatus;

    private CommonErrorCodeEnum(String code) {
        this.code = code;
    }

    private CommonErrorCodeEnum(long code, String message) {
        this(code, message, DEFAULT_LOG_LEVEL, DEFAULT_HTTP_STATUS_CODE);
    }

    private CommonErrorCodeEnum(long code, String message, HttpStatus httpStatus) {
        this(code, message, DEFAULT_LOG_LEVEL, httpStatus);
    }

    private CommonErrorCodeEnum(long code, String message, Level logLevel) {
        this(code, message, logLevel, DEFAULT_HTTP_STATUS_CODE);
    }

    private CommonErrorCodeEnum(long code, String message, Level logLevel, HttpStatus httpStatus) {
        this.code = Long.toHexString(code);
        this.message = message;
        this.logLevel = logLevel;
        this.httpStatus = httpStatus;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Level getLogLevel() {
        return this.logLevel;
    }

    @Override
    public HttpStatus getHttpStatusCode() {
        return this.httpStatus;
    }

    public BaseRuntimeException toException(Object ... args) {
        return new BaseRuntimeException((ErrorCode)this, args);
    }

    public BaseRuntimeException toException(Throwable t, Object ... args) {
        return new BaseRuntimeException((ErrorCode)this, t, args);
    }
}

