/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.exception;

import org.shoulder.core.dto.response.RestResult;
import org.shoulder.core.exception.BaseRuntimeException;
import org.shoulder.core.util.ExceptionUtil;
import org.slf4j.event.Level;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

public interface ErrorCode {
    public static final Level DEFAULT_LOG_LEVEL = Level.WARN;
    public static final HttpStatus DEFAULT_HTTP_STATUS_CODE = HttpStatus.INTERNAL_SERVER_ERROR;
    public static final SuccessCode SUCCESS = new SuccessCode();

    @NonNull
    public String getCode();

    public String getMessage();

    default public Object[] getArgs() {
        return new Object[0];
    }

    default public void setArgs(Object ... args) {
        throw new UnsupportedOperationException("not support set args");
    }

    @NonNull
    default public Level getLogLevel() {
        return DEFAULT_LOG_LEVEL;
    }

    @NonNull
    default public HttpStatus getHttpStatusCode() {
        return DEFAULT_HTTP_STATUS_CODE;
    }

    default public RestResult<Object[]> toResponse(Object ... args) {
        return new RestResult<Object[]>(this.getCode(), this.getMessage(), args == null ? this.getArgs() : args);
    }

    default public String generateDetail() {
        return ExceptionUtil.generateExceptionMessage(this.getMessage(), this.getArgs());
    }

    default public void throwRuntime() throws BaseRuntimeException {
        throw new BaseRuntimeException(this);
    }

    default public void throwRuntime(Throwable t) throws BaseRuntimeException {
        throw new BaseRuntimeException(this.getCode(), this.getMessage(), t, new Object[0]);
    }

    public static class SuccessCode
    implements ErrorCode {
        @Override
        @NonNull
        public String getCode() {
            return "0";
        }

        @Override
        public String getMessage() {
            return "success";
        }

        @Override
        public Level getLogLevel() {
            return Level.DEBUG;
        }

        @Override
        public HttpStatus getHttpStatusCode() {
            return HttpStatus.OK;
        }

        @Override
        public void throwRuntime() throws BaseRuntimeException {
        }

        @Override
        public void throwRuntime(Throwable t) throws BaseRuntimeException {
        }
    }
}

