/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.guid;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.shoulder.core.guid.LongGuidGenerator;
import org.shoulder.core.util.PaddedAtomicLong;

public class ShoulderGuidGenerator
implements LongGuidGenerator {
    private final long instanceIdShift;
    private final long timestampLeftShift;
    private final long sequenceMask;
    private final long timeEpoch;
    private long instanceId;
    private final Node[] buffer;
    private final VarHandle nodeHandle = MethodHandles.arrayElementVarHandle(Node[].class);
    private final AtomicLong latestTimeStamp = new PaddedAtomicLong(-1L);

    public ShoulderGuidGenerator(long timeStampBits, long timeEpoch, long instanceIdBits, long instanceId, long sequenceBits, int bufferSize) {
        this.timeEpoch = timeEpoch;
        this.instanceId = instanceId;
        this.instanceIdShift = sequenceBits;
        this.timestampLeftShift = sequenceBits + instanceIdBits;
        this.sequenceMask = -1L << (int)sequenceBits ^ 0xFFFFFFFFFFFFFFFFL;
        int timeEpochBits = 64 - Long.numberOfLeadingZeros(timeEpoch);
        if (timeStampBits <= 0L || timeStampBits < (long)timeEpochBits) {
            throw new IllegalArgumentException("timeStampBits or timeEpoch invalid. timeStampBits=" + timeStampBits + ", timeEpoch=" + timeEpoch);
        }
        int selfInstanceIdBits = 64 - Long.numberOfLeadingZeros(instanceId);
        if (instanceIdBits < 0L || timeStampBits < (long)selfInstanceIdBits) {
            throw new IllegalArgumentException("instanceIdBits or instanceId invalid. instanceIdBits=" + instanceIdBits + ", instanceId=" + instanceId);
        }
        if (sequenceBits <= 0L) {
            throw new IllegalArgumentException("sequenceBits must > 0. sequenceBits=" + sequenceBits);
        }
        int longBits = 63;
        if (timeStampBits + instanceIdBits + sequenceBits != 63L) {
            throw new IllegalArgumentException("timeStampBits + instanceIdBits + sequenceBits != 63 must = 63. timeStampBits=" + timeStampBits + "instanceIdBits=" + instanceIdBits + "sequenceBits=" + sequenceBits);
        }
        this.buffer = new Node[ShoulderGuidGenerator.bufferSizeFor(bufferSize)];
        Arrays.fill(this.buffer, new Node(-1L, 0L, -1L));
    }

    private static final int bufferSizeFor(int s) {
        int maximumCapacity = 0x40000000;
        int n = -1 >>> Integer.numberOfLeadingZeros(s - 1);
        return n < 0 ? 1 : (n >= maximumCapacity ? maximumCapacity : n + 1);
    }

    @Override
    public long nextId() {
        long lts;
        long minTs;
        int maxSequence = 1 << (int)this.instanceIdShift;
        long timeStamp = this.currentTimeStamp() - this.timeEpoch;
        if (timeStamp < (minTs = (lts = this.latestTimeStamp.get()) - (long)this.buffer.length)) {
            this.onTimeBackTooMuch(timeStamp, this.latestTimeStamp.get(), minTs - timeStamp);
        }
        while (true) {
            Node newNode;
            long timeStampFinal = ++timeStamp;
            int index = (int)timeStampFinal & this.buffer.length - 1;
            Node node = this.getNodeAt(index);
            if (timeStampFinal > node.timeStamp && this.casNodeAt(index, node, newNode = new Node(timeStampFinal, 1L, timeStampFinal << (int)this.timestampLeftShift | this.instanceId << (int)this.instanceIdShift))) {
                this.latestTimeStamp.incrementAndGet();
                return newNode.template;
            }
            long currentSequence = node.sequence.getAndIncrement();
            if (currentSequence >= (long)maxSequence) continue;
            return node.template | currentSequence & this.sequenceMask;
        }
    }

    @Override
    public Map<String, String> decode(long snowflakeId) {
        HashMap<String, String> map = new HashMap<String, String>(3);
        long relativeTimeStamp = snowflakeId >> (int)this.timestampLeftShift;
        map.put("relativeTimeStamp", String.valueOf(relativeTimeStamp));
        map.put("timestamp", String.valueOf(relativeTimeStamp + this.timeEpoch));
        long sequence = snowflakeId & this.sequenceMask;
        map.put("sequence", String.valueOf(sequence));
        long instanceId = snowflakeId >> (int)this.instanceIdShift & (long)(~(-1 << (int)(this.timestampLeftShift - this.instanceIdShift)));
        map.put("instanceId", String.valueOf(instanceId));
        return map;
    }

    @Override
    public long[] nextIds(int num) {
        long lts;
        long minTs;
        int maxSequence = 1 << (int)this.instanceIdShift;
        if (num < 1 || num > maxSequence) {
            throw new IllegalArgumentException("num must less than maxSequence(" + maxSequence + ")!");
        }
        long[] result = new long[num];
        long timeStamp = this.currentTimeStamp() - this.timeEpoch;
        if (timeStamp < (minTs = (lts = this.latestTimeStamp.get()) - (long)this.buffer.length)) {
            this.onTimeBackTooMuch(timeStamp, this.latestTimeStamp.get(), minTs - timeStamp);
        }
        int gotCounter = 0;
        while (true) {
            Node newNode;
            long timeStampFinal = ++timeStamp;
            int need = num - gotCounter;
            int index = (int)timeStampFinal & this.buffer.length - 1;
            Node node = this.getNodeAt(index);
            if (timeStampFinal > node.timeStamp && this.casNodeAt(index, node, newNode = new Node(timeStampFinal, need, timeStampFinal << (int)this.timestampLeftShift | this.instanceId << (int)this.instanceIdShift))) {
                this.latestTimeStamp.incrementAndGet();
                for (int i = gotCounter; i < gotCounter + need; ++i) {
                    result[i] = newNode.template | (long)i;
                }
                return result;
            }
            long currentOldValue = node.sequence.get();
            while (currentOldValue < (long)maxSequence) {
                long tryGet;
                long canGet = (long)maxSequence - currentOldValue;
                long l = tryGet = canGet > (long)need ? (long)need : canGet;
                if (node.sequence.compareAndSet(currentOldValue, currentOldValue + tryGet)) {
                    int i = gotCounter;
                    while ((long)i < (long)gotCounter + tryGet) {
                        result[i] = node.template | (long)i + currentOldValue;
                        ++i;
                    }
                    if ((long)gotCounter + tryGet == (long)num) {
                        return result;
                    }
                }
                currentOldValue = node.sequence.get();
            }
        }
    }

    protected long currentTimeStamp() {
        return System.currentTimeMillis();
    }

    protected void onTimeBackTooMuch(long timeStamp, long latestTimeStamp, long minDuration) {
    }

    private Node getNodeAt(int index) {
        return this.nodeHandle.get(this.buffer, index);
    }

    private boolean casNodeAt(int index, Node old, Node newValue) {
        return this.nodeHandle.compareAndSet(this.buffer, index, old, newValue);
    }

    public static class Node {
        final long timeStamp;
        final long template;
        final AtomicLong sequence;

        public Node(long timeStamp, long sequence, long template) {
            this.timeStamp = timeStamp;
            this.sequence = new AtomicLong(sequence);
            this.template = template;
        }
    }
}

