/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.i18;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.shoulder.core.context.AppInfo;
import org.shoulder.core.i18.Translator;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.lang.NonNull;

public class ReloadableLocaleDirectoryMessageSource
extends ReloadableResourceBundleMessageSource
implements Translator {
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();

    public ReloadableLocaleDirectoryMessageSource() {
        super.addBasenames(new String[]{"classpath*:language"});
    }

    public static MessageSourceAccessor getAccessor() {
        return new MessageSourceAccessor((MessageSource)new ReloadableLocaleDirectoryMessageSource(), AppInfo.defaultLocale());
    }

    public static MessageSourceAccessor getAccessor(Locale defaultLocale) {
        return new MessageSourceAccessor((MessageSource)new ReloadableLocaleDirectoryMessageSource(), defaultLocale);
    }

    @Override
    public Locale currentLocale() {
        Locale currentLocale = Translator.super.currentLocale();
        return currentLocale != null ? currentLocale : this.getDefaultLocale();
    }

    @NonNull
    protected List<String> calculateFilenamesForLocale(String basename, Locale locale) {
        boolean hasCountry;
        boolean hasLanguage;
        LinkedList<String> result = new LinkedList<String>(super.calculateFilenamesForLocale(basename, locale));
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuilder temp = new StringBuilder(basename);
        temp.append('/');
        boolean bl = hasLanguage = language.length() > 0;
        if (hasLanguage) {
            temp.append(language);
            result.addAll(0, this.listLanguageSourceDir(temp.toString()));
        }
        temp.append('_');
        boolean bl2 = hasCountry = country.length() > 0;
        if (hasCountry) {
            temp.append(country);
            result.addAll(0, this.listLanguageSourceDir(temp.toString()));
        }
        if (variant.length() > 0 && (hasLanguage || hasCountry)) {
            temp.append('_').append(variant);
            result.addAll(0, this.listLanguageSourceDir(temp.toString()));
        }
        return result;
    }

    @NonNull
    private List<String> listLanguageSourceDir(String basename) {
        Resource[] resources;
        try {
            resources = this.resourcePatternResolver.getResources(basename + "/*");
        }
        catch (IOException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Could resolve resourcePath [" + basename + "]"), (Throwable)e);
            }
            return Collections.emptyList();
        }
        if (resources.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(resources).map(r -> {
            try {
                return r.getURI().toString();
            }
            catch (IOException e) {
                return "";
            }
        }).filter(this::withResolveSuffix).map(name -> name.replace(".properties", "").replace(".xml", "")).collect(Collectors.toList());
    }

    private boolean withResolveSuffix(String fileName) {
        return fileName.endsWith(".properties") || fileName.endsWith(".xml");
    }
}

