/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.log;

import java.util.LinkedList;
import java.util.ServiceLoader;
import org.shoulder.core.log.ILoggerFactory;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.ShoulderLoggerSl4jFactory;

public class LoggerFactory {
    private static final ILoggerFactory DELEGATE;

    public static Logger getLogger(Class<?> key) {
        return DELEGATE.getLogger(key);
    }

    public static Logger getLogger(String key) {
        return DELEGATE.getLogger(key);
    }

    static {
        ServiceLoader<ILoggerFactory> loads = ServiceLoader.load(ILoggerFactory.class);
        LinkedList<ILoggerFactory> loggerFactoryList = new LinkedList<ILoggerFactory>();
        for (ILoggerFactory loggerFactory : loads) {
            loggerFactoryList.add(loggerFactory);
        }
        int loggerFactoryImplNum = loggerFactoryList.size();
        if (loggerFactoryImplNum == 0) {
            DELEGATE = ShoulderLoggerSl4jFactory.getInstance();
        } else {
            ILoggerFactory firstLoggerFactory = (ILoggerFactory)loggerFactoryList.get(0);
            int implNum = loggerFactoryList.size();
            DELEGATE = firstLoggerFactory;
            System.err.println("Shoulder.LoggerFactory is not unique. Found impl.size = " + implNum + ", use the first:" + firstLoggerFactory.getClass().getName());
        }
    }
}

