/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.log;

import org.shoulder.core.exception.ErrorCode;
import org.shoulder.core.log.Logger;
import org.shoulder.core.util.ExceptionUtil;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.springframework.util.StringUtils;

public class ShoulderLogger
implements Logger {
    private static final String MDC_ERROR_CODE_NAME = "S-ERR_CODE";
    private static final String MDC_TRACE_NAME = "S-TRACE";
    private static final String MDC_PARENT_ID = "parent_id";
    private static final String MDC_TRACE_ID = "trace_id";
    private static final String MDC_SPAN_ID = "span_id";
    private static final String SPACE = " ";
    private static final String ERROR_CODE_PREFIX = "[";
    private static final String ERROR_CODE_SUFFIX = "]";
    private static final String TRACE_PREFIX = "<";
    private static final String DELIMITER = ",";
    private static final String TRACE_SUFFIX = ">";
    protected final org.slf4j.Logger delegateLogger;

    public ShoulderLogger(Class<?> clazz) {
        this.delegateLogger = LoggerFactory.getLogger(clazz);
    }

    public ShoulderLogger(String name) {
        this.delegateLogger = LoggerFactory.getLogger((String)name);
    }

    public String getName() {
        return this.delegateLogger.getName();
    }

    public boolean isTraceEnabled() {
        return this.delegateLogger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.uniformLog(() -> this.delegateLogger.trace(msg));
    }

    public void trace(String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.trace(format, arg));
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.trace(format, arg1, arg2));
    }

    public void trace(String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.trace(format, arguments));
    }

    public void trace(String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.trace(msg, t));
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.delegateLogger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.uniformLog(() -> this.delegateLogger.trace(marker, msg));
    }

    public void trace(Marker marker, String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.trace(marker, format, arg));
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.trace(marker, format, arg1, arg2));
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.uniformLog(() -> this.delegateLogger.trace(marker, format, argArray));
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.trace(marker, msg, t));
    }

    public boolean isDebugEnabled() {
        return this.delegateLogger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.uniformLog(() -> this.delegateLogger.debug(msg));
    }

    public void debug(String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.debug(format, arg));
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.debug(format, arg1, arg2));
    }

    public void debug(String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.debug(format, arguments));
    }

    public void debug(String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.debug(msg, t));
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.delegateLogger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.uniformLog(() -> this.delegateLogger.debug(marker, msg));
    }

    public void debug(Marker marker, String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.debug(marker, format, arg));
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.debug(marker, format, arg1, arg2));
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.debug(marker, format, arguments));
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.debug(marker, msg, t));
    }

    public boolean isInfoEnabled() {
        return this.delegateLogger.isInfoEnabled();
    }

    public void info(String msg) {
        this.uniformLog(() -> this.delegateLogger.info(msg));
    }

    public void info(String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.info(format, arg));
    }

    public void info(String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.info(format, arg1, arg2));
    }

    public void info(String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.info(format, arguments));
    }

    public void info(String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.info(msg, t));
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.delegateLogger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.uniformLog(() -> this.delegateLogger.info(marker, msg));
    }

    public void info(Marker marker, String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.info(marker, format, arg));
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.info(marker, format, arg1, arg2));
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.info(marker, format, arguments));
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.info(marker, msg, t));
    }

    public boolean isWarnEnabled() {
        return this.delegateLogger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.uniformLog(() -> this.delegateLogger.warn(msg));
    }

    public void warn(String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.warn(format, arg));
    }

    public void warn(String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.warn(format, arguments));
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.warn(format, arg1, arg2));
    }

    public void warn(String msg, Throwable t) {
        if (t instanceof ErrorCode) {
            this.warnWithErrorCode(((ErrorCode)((Object)t)).getCode(), ((ErrorCode)((Object)t)).generateDetail(), t);
            return;
        }
        this.uniformLog(() -> this.delegateLogger.warn(msg, t));
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.delegateLogger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.uniformLog(() -> this.delegateLogger.warn(marker, msg));
    }

    public void warn(Marker marker, String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.warn(marker, format, arg));
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.warn(marker, format, arg1, arg2));
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.warn(marker, format, arguments));
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.warn(marker, msg, t));
    }

    @Override
    public void log(ErrorCode errorCode) {
        Level level = errorCode.getLogLevel();
        switch (level) {
            case WARN: {
                this.warn(errorCode);
                break;
            }
            case INFO: {
                this.info(errorCode);
                break;
            }
            case ERROR: {
                this.error(errorCode);
                break;
            }
            case DEBUG: {
                this.debug(errorCode);
                break;
            }
        }
    }

    @Override
    public void info(ErrorCode errorCode) {
        this.uniformLog(errorCode.getCode(), () -> {
            if (errorCode instanceof Throwable) {
                this.delegateLogger.info(errorCode.generateDetail(), (Throwable)((Object)errorCode));
            } else {
                this.delegateLogger.info(errorCode.generateDetail());
            }
        });
    }

    @Override
    public void debug(ErrorCode errorCode) {
        this.uniformLog(errorCode.getCode(), () -> {
            if (errorCode instanceof Throwable) {
                this.delegateLogger.debug(errorCode.generateDetail(), (Throwable)((Object)errorCode));
            } else {
                this.delegateLogger.debug(errorCode.generateDetail());
            }
        });
    }

    @Override
    public void warn(ErrorCode errorCode) {
        this.uniformLog(errorCode.getCode(), () -> {
            if (errorCode instanceof Throwable) {
                this.delegateLogger.warn(errorCode.generateDetail(), (Throwable)((Object)errorCode));
            } else {
                this.delegateLogger.warn(errorCode.generateDetail());
            }
        });
    }

    @Override
    public void warnWithErrorCode(String errorCode, String msg) {
        this.uniformLog(errorCode, () -> this.delegateLogger.warn(msg));
    }

    @Override
    public void warnWithErrorCode(String errorCode, String format, Object arg) {
        this.uniformLog(errorCode, () -> this.delegateLogger.warn(format, arg));
    }

    @Override
    public void warnWithErrorCode(String errorCode, String format, Object ... arguments) {
        this.uniformLog(errorCode, () -> this.delegateLogger.warn(format, arguments));
    }

    @Override
    public void warnWithErrorCode(String errorCode, String format, Object arg1, Object arg2) {
        this.uniformLog(errorCode, () -> this.delegateLogger.warn(format, arg1, arg2));
    }

    @Override
    public void warnWithErrorCode(String errorCode, String msg, Throwable t) {
        this.uniformLog(errorCode, () -> this.delegateLogger.warn(msg, t));
    }

    public boolean isErrorEnabled() {
        return this.delegateLogger.isErrorEnabled();
    }

    public void error(String msg) {
        this.uniformLog(() -> this.delegateLogger.error(msg));
    }

    public void error(String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.error(format, arg));
    }

    public void error(String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.error(format, arg1, arg2));
    }

    public void error(String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.error(format, arguments));
    }

    public void error(String msg, Throwable t) {
        if (t instanceof ErrorCode) {
            this.errorWithErrorCode(((ErrorCode)((Object)t)).getCode(), ((ErrorCode)((Object)t)).generateDetail(), t);
            return;
        }
        this.uniformLog(() -> this.delegateLogger.error(msg, t));
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.delegateLogger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.uniformLog(() -> this.delegateLogger.error(marker, msg));
    }

    public void error(Marker marker, String format, Object arg) {
        this.uniformLog(() -> this.delegateLogger.error(marker, format, arg));
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.uniformLog(() -> this.delegateLogger.error(marker, format, arg1, arg2));
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.uniformLog(() -> this.delegateLogger.error(marker, format, arguments));
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.uniformLog(() -> this.delegateLogger.error(marker, msg, t));
    }

    @Override
    public void error(ErrorCode errorCode) {
        this.uniformLog(errorCode.getCode(), () -> {
            if (errorCode instanceof Throwable) {
                this.delegateLogger.error(errorCode.generateDetail(), (Throwable)((Object)errorCode));
            } else {
                this.delegateLogger.error(errorCode.generateDetail());
            }
        });
    }

    @Override
    public void errorWithErrorCode(String errorCode, String msg) {
        this.uniformLog(errorCode, () -> this.delegateLogger.error(msg));
    }

    @Override
    public void errorWithErrorCode(String errorCode, String format, Object arg) {
        this.uniformLog(errorCode, () -> this.delegateLogger.error(format, arg));
    }

    @Override
    public void errorWithErrorCode(String errorCode, String format, Object arg1, Object arg2) {
        this.uniformLog(errorCode, () -> this.delegateLogger.error(format, arg1, arg2));
    }

    @Override
    public void errorWithErrorCode(String errorCode, String format, Object ... arguments) {
        this.uniformLog(errorCode, () -> this.delegateLogger.error(format, arguments));
    }

    @Override
    public void errorWithErrorCode(String errorCode, String msg, Throwable t) {
        this.uniformLog(errorCode, () -> this.delegateLogger.error(msg, t));
    }

    private void uniformLog(GeneralLogger logger) {
        String traceInfo = this.generateTraceInfo();
        if (traceInfo != null) {
            MDC.put((String)MDC_TRACE_NAME, (String)traceInfo);
        }
        logger.log();
        if (traceInfo != null) {
            MDC.remove((String)MDC_TRACE_NAME);
        }
    }

    private void uniformLog(String errorCode, GeneralLogger logger) {
        this.addErrorCodeInfo(errorCode);
        String traceInfo = this.generateTraceInfo();
        if (traceInfo != null) {
            MDC.put((String)MDC_TRACE_NAME, (String)traceInfo);
        }
        logger.log();
        if (traceInfo != null) {
            MDC.remove((String)MDC_TRACE_NAME);
        }
        this.cleanErrorCodeInfo();
    }

    String generateErrorCode(String errorCode) {
        return " [" + ExceptionUtil.formatErrorCode(errorCode) + ERROR_CODE_SUFFIX;
    }

    String generateTraceInfo() {
        String traceId = MDC.get((String)MDC_TRACE_ID);
        if (StringUtils.isEmpty((Object)traceId)) {
            return null;
        }
        String spanId = MDC.get((String)MDC_SPAN_ID);
        return " <" + traceId + DELIMITER + (spanId == null ? "" : spanId) + TRACE_SUFFIX;
    }

    void addErrorCodeInfo(String errorCode) {
        MDC.put((String)MDC_ERROR_CODE_NAME, (String)this.generateErrorCode(errorCode));
    }

    void cleanErrorCodeInfo() {
        MDC.remove((String)MDC_ERROR_CODE_NAME);
    }

    static interface GeneralLogger {
        public void log();
    }
}

