/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.log;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.shoulder.core.log.ILoggerFactory;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.ShoulderLogger;

public class ShoulderLoggerSl4jFactory
implements ILoggerFactory {
    private static final ConcurrentMap<String, Logger> LOGGER_CACHE = new ConcurrentHashMap<String, Logger>(256);

    public static ShoulderLoggerSl4jFactory getInstance() {
        return SingleTonHolder.instance;
    }

    private ShoulderLoggerSl4jFactory() {
    }

    @Override
    public Logger getLogger(Class<?> loggerClazz) {
        return this.getLogger(loggerClazz.getName());
    }

    @Override
    public Logger getLogger(String loggerName) {
        return LOGGER_CACHE.computeIfAbsent(loggerName, ShoulderLogger::new);
    }

    private static class SingleTonHolder {
        static ShoulderLoggerSl4jFactory instance = new ShoulderLoggerSl4jFactory();

        private SingleTonHolder() {
        }
    }
}

