/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.log.logback.pattern;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.text.Format;
import java.util.Arrays;
import org.apache.commons.lang3.time.FastDateFormat;

public class CachingFastDateFormatter {
    private final Format dateFormat;
    private final TimeFormatCache[] cache;
    private final VarHandle cacheHandle = MethodHandles.arrayElementVarHandle(TimeFormatCache[].class);

    public CachingFastDateFormatter(String pattern) {
        this(pattern, 32);
    }

    public CachingFastDateFormatter(String pattern, int cacheSize) {
        this.dateFormat = FastDateFormat.getInstance((String)pattern);
        this.cache = new TimeFormatCache[CachingFastDateFormatter.cacheSizeFor(cacheSize)];
        Arrays.fill(this.cache, new TimeFormatCache(-1L, null));
    }

    private static int cacheSizeFor(int s) {
        int maximumCapacity = 0x40000000;
        int n = -1 >>> Integer.numberOfLeadingZeros(s - 1);
        return n < 0 ? 1 : (n >= maximumCapacity ? maximumCapacity : n + 1);
    }

    public final String format(long now) {
        int index = (int)now & this.cache.length - 1;
        TimeFormatCache lastCache = this.getAt(index);
        if (lastCache.timestamp == now) {
            return lastCache.formatStr;
        }
        String dataFormat = this.dateFormat.format(now);
        this.weakCasAt(index, lastCache, new TimeFormatCache(now, dataFormat));
        return dataFormat;
    }

    private TimeFormatCache getAt(int index) {
        return this.cacheHandle.get(this.cache, index);
    }

    private void weakCasAt(int index, TimeFormatCache old, TimeFormatCache newValue) {
        this.cacheHandle.weakCompareAndSet(this.cache, index, old, newValue);
    }

    public static class TimeFormatCache {
        final long timestamp;
        final String formatStr;

        TimeFormatCache(long timestamp, String formatStr) {
            this.timestamp = timestamp;
            this.formatStr = formatStr;
        }
    }
}

