/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.log.logback.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.shoulder.core.log.logback.pattern.CachingFastDateFormatter;

public class ShoulderDateConverter
extends ClassicConverter {
    private CachingFastDateFormatter dateFormatter = null;

    public String convert(ILoggingEvent le) {
        long timestamp = le.getTimeStamp();
        return this.dateFormatter.format(timestamp);
    }

    public void start() {
        String datePattern = this.getFirstOption();
        if (datePattern == null) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        if (datePattern.equals("ISO8601")) {
            datePattern = "yyyy-MM-dd HH:mm:ss,SSS";
        }
        try {
            this.dateFormatter = new CachingFastDateFormatter(datePattern);
        }
        catch (IllegalArgumentException e) {
            this.addWarn("Fallback to ISO8601 for could not instantiate CachingFastDateFormatter with pattern " + datePattern, e);
            this.dateFormatter = new CachingFastDateFormatter("yyyy-MM-dd HH:mm:ss,SSS");
        }
    }
}

