/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.util.Assert;

public class ArrayUtils
extends org.apache.commons.lang3.ArrayUtils {
    public static String[] toStringArray(List<?> list) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object f : list) {
            result.add(f.toString());
        }
        return result.toArray(EMPTY_STRING_ARRAY);
    }

    public static <T> T[] toArray(Enumeration<T> e, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return result.toArray((Object[])Array.newInstance(type, result.size()));
    }

    public static Iterable<Character> toIterable(final CharSequence charSequence) {
        Iterable<Character> characters = () -> new Iterator<Character>(){
            int n = 0;

            @Override
            public boolean hasNext() {
                return this.n < charSequence.length();
            }

            @Override
            public Character next() {
                return Character.valueOf(charSequence.charAt(this.n++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return characters;
    }

    public static <S extends P, P> P[] cast(S[] sonArray, Class<P> parentType) {
        Object[] result = (Object[])Array.newInstance(parentType, sonArray.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = sonArray[i];
        }
        return result;
    }

    public static <T> T[] removeNull(T[] arr1) {
        ArrayList<T> list = new ArrayList<T>(arr1.length);
        for (T e : arr1) {
            if (e == null) continue;
            list.add(e);
        }
        if (list.size() == arr1.length) {
            return arr1;
        }
        Object[] t = (Object[])Array.newInstance(arr1.getClass().getComponentType(), list.size());
        return list.toArray(t);
    }

    public static Object[] toObject(Object obj) {
        Class<?> c = obj.getClass();
        Assert.isTrue((boolean)c.isArray());
        Class<?> priType = c.getComponentType();
        if (!priType.isPrimitive()) {
            return (Object[])obj;
        }
        if (priType == Boolean.TYPE) {
            return ArrayUtils.toObject((boolean[])((boolean[])obj));
        }
        if (priType == Byte.TYPE) {
            return ArrayUtils.toObject((byte[])((byte[])obj));
        }
        if (priType == Character.TYPE) {
            return ArrayUtils.toObject((char[])((char[])obj));
        }
        if (priType == Integer.TYPE) {
            return ArrayUtils.toObject((int[])((int[])obj));
        }
        if (priType == Long.TYPE) {
            return ArrayUtils.toObject((long[])((long[])obj));
        }
        if (priType == Float.TYPE) {
            return ArrayUtils.toObject((float[])((float[])obj));
        }
        if (priType == Double.TYPE) {
            return ArrayUtils.toObject((double[])((double[])obj));
        }
        if (priType == Short.TYPE) {
            return ArrayUtils.toObject((short[])((short[])obj));
        }
        throw new IllegalArgumentException();
    }

    public static Object toPrimitive(Object[] obj) {
        Class<?> c = obj.getClass();
        Assert.isTrue((boolean)c.isArray());
        Class<?> objType = c.getComponentType();
        if (objType == Boolean.class) {
            return ArrayUtils.toPrimitive((Boolean[])((Boolean[])obj));
        }
        if (objType == Byte.class) {
            return ArrayUtils.toPrimitive((Byte[])((Byte[])obj));
        }
        if (objType == Character.class) {
            return ArrayUtils.toPrimitive((Character[])((Character[])obj));
        }
        if (objType == Integer.class) {
            return ArrayUtils.toPrimitive((Integer[])((Integer[])obj));
        }
        if (objType == Long.class) {
            return ArrayUtils.toPrimitive((Long[])((Long[])obj));
        }
        if (objType == Float.class) {
            return ArrayUtils.toPrimitive((Float[])((Float[])obj));
        }
        if (objType == Double.class) {
            return ArrayUtils.toPrimitive((Double[])((Double[])obj));
        }
        if (objType == Short.class) {
            return ArrayUtils.toPrimitive((Short[])((Short[])obj));
        }
        throw new IllegalArgumentException();
    }

    public static <T> T[] merge(T[] array1, T[] array2) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(ArrayUtils.asList(array1));
        set.addAll(ArrayUtils.asList(array2));
        return set.toArray();
    }

    public static double[] merge(double[] array1, double[] array2) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (double str : array1) {
            list.add(str);
        }
        for (double str : array2) {
            if (list.contains(str)) continue;
            list.add(str);
        }
        return ArrayUtils.toPrimitive((Double[])list.toArray(new Double[0]));
    }

    public static <T> T[] removeDumps(T[] array) {
        ArrayList<T> list = new ArrayList<T>();
        for (T obj : array) {
            if (list.contains(obj)) continue;
            list.add(obj);
        }
        if (list.size() == array.length) {
            return array;
        }
        return list.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), list.size()));
    }

    public static <T> boolean containsAny(T[] otherContains, T[] formats) {
        for (T obj1 : otherContains) {
            for (T obj2 : formats) {
                if (!obj1.equals(obj2)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean notContains(T[] array, T obj) {
        return !ArrayUtils.contains((Object[])array, obj);
    }

    public static boolean notContains(long[] array, long obj) {
        return !ArrayUtils.contains((long[])array, (long)obj);
    }

    public static boolean notContains(short[] array, short obj) {
        return !ArrayUtils.contains((short[])array, (short)obj);
    }

    public static boolean notContains(char[] array, char obj) {
        return !ArrayUtils.contains((char[])array, (char)obj);
    }

    public static boolean notContains(double[] array, double obj) {
        return !ArrayUtils.contains((double[])array, (double)obj);
    }

    public static boolean notContains(float[] array, float obj) {
        return !ArrayUtils.contains((float[])array, (float)obj);
    }

    public static boolean notContains(byte[] array, byte obj) {
        return !ArrayUtils.contains((byte[])array, (byte)obj);
    }

    public static boolean notContains(int[] array, int obj) {
        return !ArrayUtils.contains((int[])array, (int)obj);
    }

    public static <T> T[] addElement(T[] array, T data, Class<T> componentType) {
        Object[] newArray;
        if (data == null) {
            return array;
        }
        if (array == null) {
            Assert.notNull(componentType, (String)"The componentType shoule be assigned when the array is null.");
            newArray = (Object[])Array.newInstance(componentType, 1);
            newArray[0] = data;
        } else {
            Class<?> containerType = array.getClass().getComponentType();
            if (!containerType.isAssignableFrom(data.getClass())) {
                throw new ArrayStoreException("The new element which typed " + data.getClass().getName() + " can not be put into a array whoes type is " + containerType.getName());
            }
            newArray = (Object[])Array.newInstance(containerType, array.length + 1);
            System.arraycopy(array, 0, newArray, 0, array.length);
            newArray[array.length] = data;
        }
        return newArray;
    }

    public static <T> T[] addElement(T[] array, T element) {
        if (element == null) {
            return array;
        }
        return ArrayUtils.addElement(array, element, element.getClass());
    }

    public static <T> T[] addAllElement(T[] array, T[] data) {
        if (data == null || data.length == 0) {
            return array;
        }
        if (array == null) {
            return data;
        }
        Object[] newArray = (Object[])Array.newInstance(data.getClass().getComponentType(), array.length + data.length);
        System.arraycopy(array, 0, newArray, 0, array.length);
        System.arraycopy(data, 0, newArray, array.length, data.length);
        return newArray;
    }

    public static byte[] subArray(byte[] array, int len) {
        if (array.length == len) {
            return array;
        }
        if (len > array.length) {
            len = array.length;
        }
        byte[] data = new byte[len];
        System.arraycopy(array, 0, data, 0, len);
        return data;
    }

    public static <T> T[] subArray(T[] array, int endIndexExclusive) {
        return ArrayUtils.subArray(array, 0, endIndexExclusive);
    }

    public static <T> T[] subArray(T[] array, int startIndexInclusive, int endIndexExclusive) {
        if (array == null) {
            return null;
        }
        if (startIndexInclusive < 0) {
            startIndexInclusive = 0;
        }
        if (endIndexExclusive > array.length) {
            endIndexExclusive = array.length;
        }
        int newSize = endIndexExclusive - startIndexInclusive;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            return (Object[])Array.newInstance(type, 0);
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndexInclusive, subarray, 0, newSize);
        return subarray;
    }

    public static <T> List<T> subByIndex(List<T> list, int[] indexes) {
        ArrayList<T> newList = new ArrayList<T>();
        for (int i : indexes) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public static <T> boolean fastContains(T[] list, T obj) {
        if (list == null) {
            return false;
        }
        for (T e : list) {
            if (e != obj) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean fastContains(Collection<T> list, T obj) {
        for (T e : list) {
            if (e != obj) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean fastContainsAny(Collection<T> list, T[] keys) {
        for (T e : list) {
            for (T obj : keys) {
                if (e != obj) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean fastContainsAny(T[] list, T[] keys) {
        if (list == null) {
            return false;
        }
        for (T e : list) {
            for (T obj : keys) {
                if (e != obj) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public static <T> List<T> asList(T ... args) {
        ArrayList<T> list = new ArrayList<T>(args.length + 16);
        list.addAll(Arrays.asList(args));
        return list;
    }

    public static boolean containsIgnoreCase(String[] values, String str) {
        for (String v : values) {
            if (!(v == null ? str == null : v.equalsIgnoreCase(str))) continue;
            return true;
        }
        return false;
    }

    public static Object toFixLength(Object obj, int len) {
        int length = ArrayUtils.length(obj);
        if (length == len) {
            return obj;
        }
        Object result = Array.newInstance(obj.getClass().getComponentType(), len);
        System.arraycopy(obj, 0, result, 0, Math.min(length, len));
        return result;
    }

    public static <T> List<T> doSelect(Iterable<T> list, Filter<T> filter) {
        ArrayList<T> result = new ArrayList<T>();
        for (T o : list) {
            if (!filter.accept(o)) continue;
            result.add(o);
        }
        return result;
    }

    public static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static char[] copyOf(char[] original, int newLength) {
        char[] copy = new char[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static <T> T[] copyOf(T[] original, int newLength) {
        return ArrayUtils.copyOf(original, newLength, original.getClass());
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static boolean equals(Object[] a1, Object[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int n = 0; n < a1.length; ++n) {
            if (Objects.equals(a1[n], a2[n])) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean equalsIgnoreOrder(T[] a1, T[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (T o : a1) {
            if (ArrayUtils.contains((Object[])a2, o)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreOrder(Object array1, Object array2) {
        Object[] obj1 = ArrayUtils.toObject(array1);
        Object[] obj2 = ArrayUtils.toObject(array2);
        HashSet<Object> set1 = new HashSet<Object>(Arrays.asList(obj1));
        HashSet<Object> set2 = new HashSet<Object>(Arrays.asList(obj2));
        return set1.equals(set2);
    }

    public static boolean equals(Object a1, Object a2) {
        if (a1 == a2) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        Class<?> clz1 = a1.getClass();
        Class<?> clz2 = a2.getClass();
        if (!clz1.isArray() || !clz2.isArray()) {
            throw new IllegalArgumentException("must comapre between two Array.");
        }
        clz1 = clz1.getComponentType();
        clz2 = clz2.getComponentType();
        if (clz1.isPrimitive() != clz2.isPrimitive()) {
            return false;
        }
        if (clz1 == Integer.TYPE) {
            return Arrays.equals((int[])a1, (int[])a2);
        }
        if (clz1 == Short.TYPE) {
            return Arrays.equals((short[])a1, (short[])a2);
        }
        if (clz1 == Long.TYPE) {
            return Arrays.equals((long[])a1, (long[])a2);
        }
        if (clz1 == Float.TYPE) {
            return Arrays.equals((float[])a1, (float[])a2);
        }
        if (clz1 == Double.TYPE) {
            return Arrays.equals((double[])a1, (double[])a2);
        }
        if (clz1 == Boolean.TYPE) {
            return Arrays.equals((boolean[])a1, (boolean[])a2);
        }
        if (clz1 == Byte.TYPE) {
            return Arrays.equals((byte[])a1, (byte[])a2);
        }
        if (clz1 == Character.TYPE) {
            return Arrays.equals((char[])a1, (char[])a2);
        }
        return Arrays.equals((Object[])a1, (Object[])a2);
    }

    public static int length(Object obj) {
        return Array.getLength(obj);
    }

    public static Object setValueAndExpandArray(Object obj, int index, Object value) {
        int length = Array.getLength(obj);
        Object result = obj;
        if (index < 0 && index + length >= 0) {
            index += length;
        } else if (index < 0) {
            result = ArrayUtils.toFixLength(obj, -index);
        } else if (index >= length) {
            result = ArrayUtils.toFixLength(obj, index + 1);
        }
        ArrayUtils.set(result, index, value);
        return result;
    }

    public static boolean isIndexValid(Object obj, int index) {
        int length = ArrayUtils.length(obj);
        if (index < 0) {
            index += length;
        }
        return index >= 0 && index < length;
    }

    public static Object get(Object obj, int index) {
        if (index >= 0) {
            return Array.get(obj, index);
        }
        return Array.get(obj, Array.getLength(obj) + index);
    }

    public static void set(Object obj, int index, Object value) {
        if (index >= 0) {
            Array.set(obj, index, value);
        } else {
            Array.set(obj, Array.getLength(obj) + index, value);
        }
    }

    public static Object[] intersect(Object[] ls, Object[] ls2) {
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(ls));
        set.retainAll(Arrays.asList(ls2));
        return set.toArray();
    }

    public static Object[] union(Object[] ls, Object[] ls2) {
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(ls));
        set.addAll(Arrays.asList(ls2));
        return set.toArray();
    }

    public static Object[] minus(Object[] ls, Object[] ls2) {
        HashSet<Object> set = new HashSet<Object>(Arrays.asList(ls));
        set.removeAll(Arrays.asList(ls2));
        return set.toArray();
    }

    public static Object[] xor(Object[] ls, Object[] ls2) {
        HashSet<Object> setAll = new HashSet<Object>(Arrays.asList(ls));
        setAll.addAll(Arrays.asList(ls2));
        HashSet<Object> setInter = new HashSet<Object>(Arrays.asList(ls));
        setInter.retainAll(Arrays.asList(ls2));
        setAll.removeAll(setInter);
        return setAll.toArray();
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }
}

