/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ByteUtils {
    public static byte[] randomBytes(int length) {
        byte[] safeRandom = new byte[length];
        new SecureRandom().nextBytes(safeRandom);
        return safeRandom;
    }

    public static byte[] copy(byte[] source, int index, int limit) {
        byte[] cloneBytes = new byte[limit];
        System.arraycopy(source, index, cloneBytes, 0, limit);
        return cloneBytes;
    }

    public static void copy(byte[] source, int from, byte[] destination, int index, int limit) {
        System.arraycopy(source, from, destination, index, limit);
    }

    public static void copy(byte[] source, byte[] destination, int index) {
        int limit = Integer.min(source.length, destination.length - index);
        System.arraycopy(source, 0, destination, index, limit);
    }

    public static byte[] compound(List<byte[]> bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return null;
        }
        List nonNullList = bytes.stream().filter(Objects::nonNull).collect(Collectors.toList());
        int count = nonNullList.stream().map(item -> ((byte[])item).length).reduce(0, Integer::sum);
        byte[] result = new byte[count];
        int length = 0;
        for (byte[] blockBytes : nonNullList) {
            ByteUtils.copy(blockBytes, 0, result, length, blockBytes.length);
            length += blockBytes.length;
        }
        return result;
    }

    public static byte[] intToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static byte[] toBytes(long longNum) {
        int longBytes = 8;
        int byteBits = 8;
        byte[] result = new byte[longBytes];
        int mask = (longBytes - 1) * byteBits;
        int i = 0;
        while (i < result.length) {
            result[i] = (byte)(longNum >> mask & 0xFFL);
            ++i;
            mask -= byteBits;
        }
        return result;
    }

    public static int bytesToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static byte[] toBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    public static int toInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (bytes[i] & 0xFF) << shift;
        }
        return value;
    }

    public static long toLong(byte[] bytes) throws IOException {
        ByteArrayInputStream bai = new ByteArrayInputStream(bytes);
        DataInputStream dis = new DataInputStream(bai);
        return dis.readLong();
    }

    public static boolean isEmpty(byte[] data) {
        return data == null || data.length == 0;
    }

    public static boolean isNotEmpty(byte[] data) {
        return !ByteUtils.isEmpty(data);
    }
}

