/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Objects;
import org.shoulder.core.context.AppInfo;
import org.springframework.lang.NonNull;

public class ColorString {
    private static final String COLOR_PREFIX;
    private static final String RESET;
    public static final int FONT_COLOR = 30;
    public static final int BG_COLOR = 40;
    public static final int FONT_COLOR_LIGHT = 90;
    public static final int BG_COLOR_LIGHT = 100;
    public static final int BLACK = 0;
    public static final int RED = 1;
    public static final int GREEN = 2;
    public static final int YELLOW = 3;
    public static final int BLUE = 4;
    public static final int MAGENTA = 5;
    public static final int CYAN = 6;
    public static final int WHITE = 7;
    private CharSequence content;
    private int style = 0;
    private int color = 30;

    public ColorString() {
    }

    public ColorString(CharSequence content) {
        this.content = content;
    }

    public ColorString(CharSequence content, Style style, int color) {
        this.content = content;
        this.style(style);
        this.color(color);
    }

    public int getStyle() {
        return this.style;
    }

    public ColorString style(Style style) {
        this.style = style.getCode();
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public ColorString color(int color) {
        this.color = color + 30;
        return this;
    }

    public ColorString lColor(int color) {
        this.color = color + 90;
        return this;
    }

    public ColorString bgColor(int color) {
        this.color = color + 40;
        return this;
    }

    public ColorString lbgColor(int color) {
        this.color = color + 100;
        return this;
    }

    public CharSequence getContent() {
        return this.content;
    }

    public ColorString setContent(CharSequence content) {
        this.content = content;
        return this;
    }

    @NonNull
    public String toString() {
        return COLOR_PREFIX + this.style + ";" + this.color + "m" + this.content + RESET;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ColorString)) {
            return o instanceof CharSequence && this.content.equals(o);
        }
        ColorString that = (ColorString)o;
        return this.style == that.style && this.color == that.color && this.content.equals(that.content);
    }

    public int hashCode() {
        return Objects.hash(this.style, this.color, this.content);
    }

    static {
        HashMap<Charset, Character> charsetMap = new HashMap<Charset, Character>();
        charsetMap.put(StandardCharsets.UTF_8, Character.valueOf('\u001b'));
        charsetMap.put(StandardCharsets.UTF_16, Character.valueOf('\u0017'));
        COLOR_PREFIX = charsetMap.getOrDefault(AppInfo.charset(), Character.valueOf('\u001b')) + "[";
        RESET = COLOR_PREFIX + "0m";
    }

    public static enum Style {
        NORMAL(0),
        BOLD(1),
        ITALIC(3),
        TWINKLE(6),
        DELETE(9),
        UNDERLINE(24);

        private final int code;

        private Style(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }
    }
}

