/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.util.stream.IntStream;
import org.shoulder.core.util.ColorString;
import org.springframework.lang.NonNull;

public class ColorStringBuilder
implements CharSequence {
    private static final String NEW_LINE_SEPARATOR = System.getProperty("line.separator");
    private StringBuilder delegateBuilder;

    public ColorStringBuilder() {
        this.delegateBuilder = new StringBuilder();
    }

    public ColorStringBuilder(CharSequence seq) {
        this.delegateBuilder = new StringBuilder(seq);
    }

    public int compareTo(StringBuilder another) {
        return this.delegateBuilder.compareTo(another);
    }

    public ColorStringBuilder color(CharSequence c, int color) {
        this.delegateBuilder.append(new ColorString(c).color(color));
        return this;
    }

    public ColorStringBuilder black(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(0));
        return this;
    }

    public ColorStringBuilder red(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(1));
        return this;
    }

    public ColorStringBuilder green(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(2));
        return this;
    }

    public ColorStringBuilder yellow(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(3));
        return this;
    }

    public ColorStringBuilder blue(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(4));
        return this;
    }

    public ColorStringBuilder magenta(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(5));
        return this;
    }

    public ColorStringBuilder cyan(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(6));
        return this;
    }

    public ColorStringBuilder white(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).color(7));
        return this;
    }

    public ColorStringBuilder black(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 0);
        if (light != null) {
            colorString.lColor(0);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder red(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 1);
        if (light != null) {
            colorString.lColor(1);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder green(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 2);
        if (light != null) {
            colorString.lColor(2);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder yellow(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 3);
        if (light != null) {
            colorString.lColor(3);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder blue(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 4);
        if (light != null) {
            colorString.lColor(4);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder magenta(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 5);
        if (light != null) {
            colorString.lColor(5);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder cyan(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 6);
        if (light != null) {
            colorString.lColor(6);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder white(CharSequence c, ColorString.Style style, boolean ... light) {
        ColorString colorString = new ColorString(c, style, 7);
        if (light != null) {
            colorString.lColor(7);
        }
        this.delegateBuilder.append(colorString);
        return this;
    }

    public ColorStringBuilder lBlack(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(0));
        return this;
    }

    public ColorStringBuilder lRed(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(1));
        return this;
    }

    public ColorStringBuilder lGreen(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(2));
        return this;
    }

    public ColorStringBuilder lYellow(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(3));
        return this;
    }

    public ColorStringBuilder lBlue(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(4));
        return this;
    }

    public ColorStringBuilder lMagenta(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(5));
        return this;
    }

    public ColorStringBuilder lCyan(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(6));
        return this;
    }

    public ColorStringBuilder lWhite(CharSequence c) {
        this.delegateBuilder.append(new ColorString(c).lColor(7));
        return this;
    }

    public ColorStringBuilder newLine() {
        this.delegateBuilder.append(NEW_LINE_SEPARATOR);
        return this;
    }

    public ColorStringBuilder newLine(String s) {
        return this.newLine().append(s);
    }

    public ColorStringBuilder newLine(CharSequence s) {
        return this.newLine().append(s);
    }

    public ColorStringBuilder tab() {
        this.delegateBuilder.append('\t');
        return this;
    }

    public ColorStringBuilder append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public ColorStringBuilder append(String str) {
        this.delegateBuilder.append(str);
        return this;
    }

    public ColorStringBuilder append(StringBuffer sb) {
        this.delegateBuilder.append(sb);
        return this;
    }

    public ColorStringBuilder append(CharSequence s) {
        this.delegateBuilder.append(s);
        return this;
    }

    public ColorStringBuilder append(CharSequence s, int start, int end) {
        this.delegateBuilder.append(s, start, end);
        return this;
    }

    public ColorStringBuilder append(char[] str) {
        this.delegateBuilder.append(str);
        return this;
    }

    public ColorStringBuilder append(char[] str, int offset, int len) {
        this.delegateBuilder.append(str, offset, len);
        return this;
    }

    public ColorStringBuilder append(boolean b) {
        this.delegateBuilder.append(b);
        return this;
    }

    public ColorStringBuilder append(char c) {
        this.delegateBuilder.append(c);
        return this;
    }

    public ColorStringBuilder append(int i) {
        this.delegateBuilder.append(i);
        return this;
    }

    public ColorStringBuilder append(long lng) {
        this.delegateBuilder.append(lng);
        return this;
    }

    public ColorStringBuilder append(float f) {
        this.delegateBuilder.append(f);
        return this;
    }

    public ColorStringBuilder append(double d) {
        this.delegateBuilder.append(d);
        return this;
    }

    public ColorStringBuilder appendCodePoint(int codePoint) {
        this.delegateBuilder.appendCodePoint(codePoint);
        return this;
    }

    public ColorStringBuilder delete(int start, int end) {
        this.delegateBuilder.delete(start, end);
        return this;
    }

    public ColorStringBuilder deleteCharAt(int index) {
        this.delegateBuilder.deleteCharAt(index);
        return this;
    }

    public ColorStringBuilder replace(int start, int end, String str) {
        this.delegateBuilder.replace(start, end, str);
        return this;
    }

    public ColorStringBuilder insert(int index, char[] str, int offset, int len) {
        this.delegateBuilder.insert(index, str, offset, len);
        return this;
    }

    public ColorStringBuilder insert(int offset, Object obj) {
        this.delegateBuilder.insert(offset, obj);
        return this;
    }

    public ColorStringBuilder insert(int offset, String str) {
        this.delegateBuilder.insert(offset, str);
        return this;
    }

    public ColorStringBuilder insert(int offset, char[] str) {
        this.delegateBuilder.insert(offset, str);
        return this;
    }

    public ColorStringBuilder insert(int dstOffset, CharSequence s) {
        this.delegateBuilder.insert(dstOffset, s);
        return this;
    }

    public ColorStringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        this.delegateBuilder.insert(dstOffset, s, start, end);
        return this;
    }

    public ColorStringBuilder insert(int offset, boolean b) {
        this.delegateBuilder.insert(offset, b);
        return this;
    }

    public ColorStringBuilder insert(int offset, char c) {
        this.delegateBuilder.insert(offset, c);
        return this;
    }

    public ColorStringBuilder insert(int offset, int i) {
        this.delegateBuilder.insert(offset, i);
        return this;
    }

    public ColorStringBuilder insert(int offset, long l) {
        this.delegateBuilder.insert(offset, l);
        return this;
    }

    public ColorStringBuilder insert(int offset, float f) {
        this.delegateBuilder.insert(offset, f);
        return this;
    }

    public ColorStringBuilder insert(int offset, double d) {
        this.delegateBuilder.insert(offset, d);
        return this;
    }

    public int indexOf(String str) {
        return this.delegateBuilder.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this.delegateBuilder.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this.delegateBuilder.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this.delegateBuilder.lastIndexOf(str, fromIndex);
    }

    public ColorStringBuilder reverse() {
        this.delegateBuilder.reverse();
        return this;
    }

    @Override
    @NonNull
    public String toString() {
        return this.delegateBuilder.toString();
    }

    public boolean equals(Object o) {
        return this.delegateBuilder.equals(o);
    }

    public int hashCode() {
        return this.delegateBuilder.hashCode();
    }

    @Override
    public int length() {
        return this.delegateBuilder.length();
    }

    @Override
    public char charAt(int index) {
        return this.delegateBuilder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.delegateBuilder.subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.delegateBuilder.chars();
    }

    @Override
    public IntStream codePoints() {
        return this.delegateBuilder.codePoints();
    }
}

