/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.shoulder.core.constant.ByteSpecification;

public class EncodeUtils {
    private static final Charset ENCODING = ByteSpecification.STD_CHAR_SET;
    private static final char[] BASE62 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    public static String encodeHex(byte[] input) {
        return new String(Hex.encodeHex((byte[])input));
    }

    public static byte[] decodeHex(String input) {
        try {
            return Hex.decodeHex((char[])input.toCharArray());
        }
        catch (DecoderException e) {
            return null;
        }
    }

    public static String encodeBase64(byte[] input) {
        return new String(Base64.encodeBase64((byte[])input));
    }

    public static String encodeBase64(String input) {
        return new String(Base64.encodeBase64((byte[])input.getBytes(ENCODING)), ENCODING);
    }

    public static byte[] decodeBase64(String input) {
        return Base64.decodeBase64((byte[])input.getBytes());
    }

    public static String decodeBase64String(String input) {
        return new String(Base64.decodeBase64((byte[])input.getBytes(ENCODING)), ENCODING);
    }

    public static String encodeBase62(byte[] input) {
        char[] chars = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            chars[i] = BASE62[(input[i] & 0xFF) % BASE62.length];
        }
        return new String(chars);
    }

    public static String encodeUrl(String part) {
        return URLEncoder.encode(part, ENCODING);
    }

    public static String decodeUrl(String part) {
        return URLDecoder.decode(part, ENCODING);
    }
}

