/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.shoulder.core.context.AppInfo;

public class ExceptionUtil {
    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static String generateExceptionMessage(String message, Object ... args) {
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            message = MessageFormat.format(message, args);
        }
        return message;
    }

    public static String generateExceptionMessageWithCode(String errorCode, String message, Object ... args) {
        return "[errorCode=" + errorCode + "] " + ExceptionUtil.generateExceptionMessage(message, args);
    }

    public static String getRootErrorMessage(Exception e) {
        Throwable root = ExceptionUtils.getRootCause((Throwable)e);
        Throwable throwable = root = root == null ? e : root;
        if (root == null) {
            return "";
        }
        String msg = root.getMessage();
        if (msg == null) {
            return "null";
        }
        return StringUtils.defaultString((String)msg);
    }

    public static String formatErrorCode(String errorCode) {
        if ("0".equals(errorCode)) {
            return "0";
        }
        return AppInfo.errorCodePrefix() + errorCode;
    }

    public static String formatErrorCode(Long errorCode) {
        return ExceptionUtil.formatErrorCode(String.format("%08x", errorCode));
    }
}

