/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadUtils {
    public static final String UPLOAD_FILE_ROOT_PATH = "upload";
    public static final String COMMA_SEPARATOR = ",";
    private static final Logger logger = LoggerFactory.getLogger(FileUploadUtils.class);
    private static final String TEMP_DIR_NAME = "temp";
    private static final String FILE_SEPARATOR = File.separator;

    private static void ensureParentFolder(File file) {
        File f = file.getParentFile();
        if (!f.exists() && !f.mkdirs()) {
            throw new RuntimeException("can not ensure exist for " + f.getAbsolutePath());
        }
    }

    public static String getUploadFileRootPath() {
        HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        ServletContext servletContext = request.getSession().getServletContext();
        if (servletContext != null) {
            return servletContext.getRealPath(FILE_SEPARATOR + UPLOAD_FILE_ROOT_PATH);
        }
        throw new RuntimeException("not a servlet environment!");
    }

    public static String getUploadFileTempPath() {
        return FileUploadUtils.getUploadFileRootPath() + FILE_SEPARATOR + TEMP_DIR_NAME;
    }

    public static File getFileFromMultiPartFile(MultipartFile file) throws Exception {
        File goalFile = new File(new File(FileUploadUtils.getUploadFileTempPath()), UUID.randomUUID().toString());
        FileUploadUtils.ensureParentFolder(goalFile);
        file.transferTo(goalFile);
        return goalFile;
    }

    public static boolean exportDataToCsv(OutputStream os, String charSet, String csvHeader, List<String> dataList) {
        try {
            OutputStreamWriter osw = new OutputStreamWriter(os, charSet);
            BufferedWriter bfw = new BufferedWriter(osw);
            bfw.append(csvHeader).append("\r");
            if (dataList != null && !dataList.isEmpty()) {
                for (String data : dataList) {
                    bfw.append(data).append("\r");
                }
            }
            bfw.flush();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> importDataFromCsv(File file) {
        ArrayList<String> dataList = new ArrayList<String>();
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = br.readLine()) != null) {
                dataList.add(line);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("load by csv fail from " + file.getAbsolutePath());
        }
        return dataList;
    }
}

