/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpUtils {
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$");
    private static String LOCAL_IP_CACHE;
    private static String LOCAL_MAC_CACHE;

    public static boolean validateIpv4(String ip) {
        if (StringUtils.isEmpty((CharSequence)ip)) {
            return false;
        }
        Matcher matcher = IPV4_PATTERN.matcher(ip);
        return matcher.matches();
    }

    public static String getMac() {
        return LOCAL_MAC_CACHE;
    }

    public static String getIp() {
        return LOCAL_IP_CACHE;
    }

    public static InetAddress getLocalNetAddress() throws SocketException {
        Enumeration<NetworkInterface> enu = NetworkInterface.getNetworkInterfaces();
        while (enu.hasMoreElements()) {
            NetworkInterface ni = enu.nextElement();
            if (ni.isLoopback()) continue;
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isAnyLocalAddress()) continue;
                return address;
            }
        }
        throw new RuntimeException("No validated local address!");
    }

    private static String getMac(InetAddress inetAddress) {
        try {
            String macAddress;
            byte[] mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append("-");
                }
                sb.append((String)((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? "0" + s : s));
            }
            LOCAL_MAC_CACHE = macAddress = sb.toString().toUpperCase();
            return macAddress;
        }
        catch (Exception e) {
            return "00-00-00-00-00-00";
        }
    }

    static {
        try {
            InetAddress inetAddress = IpUtils.getLocalNetAddress();
            LOCAL_IP_CACHE = inetAddress.getHostAddress();
            LOCAL_MAC_CACHE = IpUtils.getMac(inetAddress);
        }
        catch (Exception e) {
            log.warn("can't find local network address info.", (Throwable)e);
            LOCAL_IP_CACHE = "127.0.0.1";
            LOCAL_MAC_CACHE = "00-00-00-00-00-00";
        }
    }
}

