/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.PackageVersion;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.shoulder.core.context.AppInfo;
import org.shoulder.core.exception.JsonRuntimeException;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static ObjectMapper JSON_MAPPER = JsonUtils.createObjectMapper();

    public static String toJson(Object object) {
        try {
            return JSON_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonRuntimeException(e);
        }
    }

    public static String toJson(Object object, String ... ignoreProperties) {
        return JsonUtils.toJson(object, null, ignoreProperties);
    }

    public static String toJson(Object object, HashSet<String> ignoreProperties) {
        return JsonUtils.toJson(object, null, ignoreProperties);
    }

    public static String toJson(Object object, BeanSerializerModifier modifier, String ... ignoreProperties) {
        return JsonUtils.toJson(object, modifier, new HashSet<String>(Arrays.asList(ignoreProperties)));
    }

    public static String toJson(Object object, BeanSerializerModifier modifier, HashSet<String> ignoreProperties) {
        ObjectMapper mapper = JSON_MAPPER.copy();
        try {
            return mapper.setSerializerFactory(mapper.getSerializerFactory().withSerializerModifier(modifier)).setFilterProvider((FilterProvider)JsonUtils.createIgnorePropertiesProvider("_temp_ignore", ignoreProperties)).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonRuntimeException(e);
        }
    }

    public static <T> T toObject(String json, TypeReference<T> type) {
        try {
            return (T)JSON_MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new JsonRuntimeException(e);
        }
    }

    public static <T> T toObject(String json, Class<T> clazz, Class<?> ... paramClasses) {
        ObjectMapper mapper = JSON_MAPPER.copy();
        JavaType javaType = mapper.getTypeFactory().constructParametricType(clazz, (Class[])paramClasses);
        try {
            return (T)mapper.readValue(json, javaType);
        }
        catch (JsonProcessingException e) {
            throw new JsonRuntimeException(e);
        }
    }

    public static void setJsonMapper(ObjectMapper jsonMapper) {
        LoggerFactory.getLogger(JsonUtils.class).info("JSON_MAPPER changed to " + jsonMapper);
        JSON_MAPPER = jsonMapper;
    }

    public static ObjectMapper createObjectMapper() {
        return JsonUtils.createObjectMapper(null);
    }

    public static ObjectMapper createObjectMapper(BeanSerializerModifier modifier) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setLocale(AppInfo.defaultLocale());
        objectMapper.setTimeZone(AppInfo.timeZone());
        objectMapper.setDateFormat((DateFormat)new SimpleDateFormat(AppInfo.dateFormat(), AppInfo.defaultLocale()));
        objectMapper.configure(JsonReadFeature.ALLOW_UNESCAPED_CONTROL_CHARS.mappedFeature(), true);
        objectMapper.configure(JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER.mappedFeature(), true);
        objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        if (modifier != null) {
            objectMapper.setSerializerFactory(objectMapper.getSerializerFactory().withSerializerModifier(modifier));
        }
        objectMapper.registerModule((Module)new DateEnhancerJacksonModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule());
        objectMapper.findAndRegisterModules();
        return objectMapper;
    }

    public static ObjectMapper setIgnoreFilter(ObjectMapper mapper, String ... properties) {
        mapper.setFilterProvider((FilterProvider)JsonUtils.createIgnorePropertiesProvider("_temp_ignore", new HashSet<String>(Arrays.asList(properties))));
        return mapper;
    }

    public static SimpleFilterProvider createIgnorePropertiesProvider(String filterName, Set<String> ignores) {
        return new SimpleFilterProvider().addFilter(filterName, SimpleBeanPropertyFilter.serializeAllExcept(ignores));
    }

    public static class DateEnhancerJacksonModule
    extends SimpleModule {
        public DateEnhancerJacksonModule() {
            super(PackageVersion.VERSION);
            String dateFormatStr = "yyyy-MM-dd";
            DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern(dateFormatStr);
            this.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(dateFormatter));
            this.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(dateFormatter));
            String timeFormatStr = "HH:mm:ss";
            DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern(timeFormatStr);
            this.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(timeFormat));
            this.addDeserializer(LocalTime.class, (JsonDeserializer)new LocalTimeDeserializer(timeFormat));
            String datetimeFormatStr = dateFormatStr + " " + timeFormatStr;
            DateTimeFormatter datetimeFormat = DateTimeFormatter.ofPattern(datetimeFormatStr);
            this.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(datetimeFormat));
            this.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(datetimeFormat));
        }
    }
}

