/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.shoulder.core.util.ArrayUtils;

public class RegexpUtils {
    public static final String MATCH_ANY_STRING = ".*?";
    public static final char[] STAR_QUESTION = new char[]{'*', '?', '+'};
    public static final String MATCH_ANY = ".";
    public static final String MATCH_NUMBER = "\\d";
    public static final String MATCH_NON_NUMBER = "\\D";
    public static final String MATCH_BLANK = "\\s";
    public static final String MATCH_NON_BLANK = "\\S";
    public static final String MATCH_WORD_CHAR = "\\w";
    public static final String MATCH_NON_WORD_CHAR = "\\W";
    public static final String MATCH_START = "^";
    public static final String MATCH_END = "$";
    public static final String COUNT_0_N = "*";
    public static final String COUNT_1_N = "+";
    public static final String COUNT_0_1 = "?";
    public static final String COUNT_0_N_RELUCTANT = "*?";
    public static final String COUNT_1_N_RELUCTANT = "+?";
    public static final String COUNT_0_1_RELUCTANT = "??";
    public static final Pattern CHAR_NUM_UNDERLINE = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]{4,15}$");
    public static final Pattern NO_SPECIAL = Pattern.compile("^[^'/\\\\:*?\"<>|]{1,32}$");
    public static final Pattern CHINESE = Pattern.compile("\\u4e00-\\u9fa5");
    public static final Pattern HREF_LINK = Pattern.compile("([hH])([rR])([eE])([fF]) *= *(['\"])?(\\w|\\\\|/|\\.)+('|\"| *|>)?");
    public static final Pattern NUM = Pattern.compile("(-?\\d*)(\\.\\d+)?");
    public static final Pattern INTEGER = Pattern.compile("\\d+");
    public static final Pattern BASE_64 = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{4}|[A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)$");
    public static final Pattern PHONE_NUM = Pattern.compile("[1]([3-9])[0-9]{9}");
    public static final Pattern PHONE_NUM_STRICT = Pattern.compile("[1](([3][0-9])|([4][5-9])|([5][0-3,5-9])|([6][5,6])|([7][0-8])|([8][0-9])|([9][1,8,9]))[0-9]{8}");
    public static final Pattern ID_CARD = Pattern.compile("\\d{15}|\\d{18}|\\d{17}x|\\d{17}X");
    public static final Pattern POSTCODE = Pattern.compile("[1-9]\\d{5}(?!\\d)");
    public static final Pattern LICENSE_PLATE = Pattern.compile("([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c](([A-HJ-Z][A-HJ-NP-Z0-9]{5})|([A-HJ-Z](([DF][A-HJ-NP-Z0-9][0-9]{4})|([0-9]{5}[DF])))|([A-HJ-Z][A-D0-9][0-9]{3}\u8b66)))|([0-9]{6}\u4f7f)|((([\u6caa\u7ca4\u5ddd\u4e91\u6842\u9102\u9655\u8499\u85cf\u9ed1\u8fbd\u6e1d]A)|\u9c81B|\u95fdD|\u8499E|\u8499H)[0-9]{4}\u9886)|(WJ[\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u00b7\u2022][0-9]{4}[TDSHBXJ0-9])|([VKHBSLJNGCE][A-DJ-PR-TVY][0-9]{5})");
    public static final Pattern QQ = Pattern.compile("[1-9]\\d{4,10}");
    public static final Pattern WE_CHAT = Pattern.compile("[a-zA-Z][-_a-zA-Z0-9]{5,19}");
    public static final Pattern EMAIL = Pattern.compile("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    public static final Pattern URL = Pattern.compile("[a-zA-z]+://[^\\s]*");
    public static final Pattern IP = Pattern.compile("(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])");
    public static final Pattern PORT = Pattern.compile("([0-9]|[1-9]\\d{1,3}|[1-5]\\d{4}|6[0-4]\\d{3}|65[0-4]\\d{2}|655[0-2]\\d|6553[0-5])");
    public static final Pattern MAC = Pattern.compile("([A-Fa-f0-9]{2}-){5}[A-Fa-f0-9]{2}");
    public static final char[] REGEXP_KEY_CHARS = new char[]{'\\', '(', ')', '{', '}', '[', ']', '*', '+', '?', '.', '$', '^', '|'};
    private static final int COMPILE_CACHE_SIZE = 64;
    private static final Map<String, Pattern> CACHE = new ConcurrentHashMap<String, Pattern>(64);

    public static String simpleMatchToRegexp(String key) {
        key = RegexpUtils.escapeRegChars(key, STAR_QUESTION);
        key = StringUtils.replaceEach((String)key, (String[])new String[]{COUNT_0_N, COUNT_0_1, COUNT_1_N}, (String[])new String[]{".*", ".?", ".+"});
        return key;
    }

    public static Pattern simplePattern(String key, boolean IgnoreCase, boolean matchStart, boolean matchEnd, boolean wildcardSpace) {
        if (IgnoreCase) {
            key = key.toUpperCase();
        }
        Object regStr = RegexpUtils.simpleMatchToRegexp(key);
        regStr = (matchStart ? "" : MATCH_ANY_STRING) + (String)(wildcardSpace ? key.replace(" ", "\\s+") : regStr) + (matchEnd ? "" : MATCH_ANY_STRING);
        return Pattern.compile((String)regStr);
    }

    public static String escapeRegChars(String key, char[] keeps) {
        for (char c : REGEXP_KEY_CHARS) {
            if (ArrayUtils.contains((char[])keeps, (char)c)) continue;
            key = key.replace(String.valueOf(c), "\\" + c);
        }
        return key;
    }

    public static boolean contains(String str, String regexp) {
        return RegexpUtils.matches(str, regexp, false);
    }

    public static boolean matches(String str, String regexp) {
        return RegexpUtils.matches(str, regexp, true);
    }

    public static boolean matches(String str, String regexp, boolean strict) {
        Matcher m = RegexpUtils.getMatcher(str, regexp, strict);
        return m.matches();
    }

    public static String[] getSimpleMatchResult(String str, String key, boolean strict) {
        key = RegexpUtils.escapeRegChars(key, STAR_QUESTION);
        key = StringUtils.replaceEach((String)key, (String[])new String[]{COUNT_0_N, COUNT_0_1, COUNT_1_N}, (String[])new String[]{"(.*)", "(.?)", "(.+)"});
        return RegexpUtils.getMatcherResult(str, key, strict);
    }

    public static String[] getMatcherResult(String str, String regexp, boolean strict) {
        Matcher m;
        if (!strict) {
            boolean hasRight;
            String tmp = StringUtils.remove((String)(str = StringUtils.remove((String)str, (String)"\\(")), (String)"\\)");
            boolean hasLeft = tmp.indexOf(40) > -1;
            boolean bl = hasRight = tmp.indexOf(41) > -1;
            if (!hasLeft || !hasRight) {
                regexp = "(" + (String)regexp + ")";
            }
        }
        if (!(m = RegexpUtils.getMatcher(str, (String)regexp, strict)).matches()) {
            return null;
        }
        int n = m.groupCount();
        if (n == 0) {
            return new String[]{m.group()};
        }
        String[] result = new String[n];
        for (int i = 1; i <= n; ++i) {
            result[i - 1] = m.group(i);
        }
        return result;
    }

    private static Matcher getMatcher(String str, String regexp, boolean strict) {
        Pattern p;
        if (!strict) {
            regexp = MATCH_ANY_STRING + (String)regexp + MATCH_ANY_STRING;
        }
        if ((p = CACHE.get(regexp)) == null) {
            p = Pattern.compile((String)regexp);
            RegexpUtils.addToCache(p);
        }
        return p.matcher(str);
    }

    private static void addToCache(Pattern p) {
        if (CACHE.size() == 64) {
            CACHE.clear();
        }
        CACHE.put(p.pattern(), p);
    }
}

