/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.shoulder.core.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ServletUtil {
    private static final String XML_HTTP_REQ_VALUE = "XMLHttpRequest";
    private static Logger logger = LoggerFactory.getLogger(ServletUtil.class);

    public static String getCookie(String cookieName) {
        HttpServletRequest request = ServletUtil.getRequest();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public static void setCookie(String cookieName, String cookieValue, int maxSecond) {
        HttpServletResponse response = ServletUtil.getResponse();
        Cookie cookie = new Cookie(cookieName, cookieValue);
        cookie.setMaxAge(maxSecond);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static void expireCookie(String cookieName) {
        HttpServletResponse response = ServletUtil.getResponse();
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        cookie.setPath("/");
        response.addCookie(cookie);
    }

    public static HttpServletRequest getRequest() {
        return ServletUtil.getRequestAttributes().getRequest();
    }

    public static HttpServletResponse getResponse() {
        return ServletUtil.getRequestAttributes().getResponse();
    }

    public static HttpSession getSession() {
        return ServletUtil.getRequestAttributes().getRequest().getSession();
    }

    public static Object getSessionAttribute(String sessionKeyName) {
        return ServletUtil.getSession().getAttribute(sessionKeyName);
    }

    public static void setSessionAttribute(String sessionKey, Object value) {
        ServletUtil.getSession().setAttribute(sessionKey, value);
    }

    @NonNull
    public static ServletRequestAttributes getRequestAttributes() {
        ServletRequestAttributes sa = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sa == null) {
            throw new IllegalStateException("Not a servlet context!");
        }
        return sa;
    }

    public static Map<String, String> getRequestHeaders() {
        return ServletUtil.getRequestHeaders(ServletUtil.getRequest(), false);
    }

    public static Map<String, String> getRequestHeaders(HttpServletRequest request, boolean sortByKey) {
        TreeMap<String, String> headers = sortByKey ? new TreeMap() : new HashMap();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static Map<String, String> getResponseHeaders() {
        return ServletUtil.getResponseHeaders(ServletUtil.getResponse(), false);
    }

    public static Map<String, String> getResponseHeaders(HttpServletResponse response, boolean sortByKey) {
        Collection headerNames = response.getHeaderNames();
        TreeMap<String, String> headers = sortByKey ? new TreeMap() : new HashMap(headerNames.size());
        for (String headerName : headerNames) {
            String headerValue = response.getHeader(headerName);
            headers.put(headerName, headerValue);
        }
        return headers;
    }

    public static boolean isAjax(HttpServletRequest request) {
        String requestHeader = request.getHeader("X-Requested-With");
        return XML_HTTP_REQ_VALUE.equalsIgnoreCase(StringUtils.trim((String)requestHeader));
    }

    public static boolean isBrowser(HttpServletRequest request) {
        return StringUtils.startsWith((CharSequence)request.getHeader("User-Agent"), (CharSequence)"Mozilla");
    }

    public static boolean isAcceptPage(HttpServletRequest request) {
        return request.getHeader("Accept").contains("text/html") || request.getHeader("Accept").contains("*/*");
    }

    public static boolean isBrowserPage(HttpServletRequest request) {
        return ServletUtil.isBrowser(request) && ServletUtil.isAcceptPage(request) && !ServletUtil.isAjax(request);
    }

    public static boolean acceptJson(HttpServletRequest request) {
        String accept = request.getHeader("Accept");
        return accept.startsWith("application/json");
    }

    public static boolean isAjax() {
        return ServletUtil.isAjax(ServletUtil.getRequest());
    }

    public static boolean needReturnJson() {
        HttpServletRequest request = ServletUtil.getRequest();
        return ServletUtil.acceptJson(request) || ServletUtil.isAjax(request);
    }

    public static String getServerURL() {
        HttpServletRequest request = ServletUtil.getRequest();
        String requestUrl = request.getRequestURL().toString();
        StringBuilder serverUrl = new StringBuilder("http");
        if (requestUrl.indexOf("https") > 0) {
            serverUrl.append("s://");
        } else {
            serverUrl.append("://");
        }
        serverUrl.append(request.getServerName());
        serverUrl.append(':');
        serverUrl.append(request.getServerPort());
        return serverUrl.toString();
    }
}

