/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public final class SpringUtils {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    public static <T> T getBean(String name) throws BeansException {
        return (T)SpringUtils.getBeanFactory().getBean(name);
    }

    public static <T> T getBean(Class<T> clz) throws BeansException {
        return (T)SpringUtils.getBeanFactory().getBean(clz);
    }

    public static boolean containsBean(String name) {
        return SpringUtils.getBeanFactory().containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return SpringUtils.getBeanFactory().isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return SpringUtils.getBeanFactory().getType(name);
    }

    public static String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return SpringUtils.getBeanFactory().getAliases(name);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> cls) {
        try {
            return SpringUtils.getBeanFactory().getBeansOfType(cls);
        }
        catch (IllegalStateException | BeansException e) {
            return Collections.emptyMap();
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> cls, ServletContext sc) {
        if (sc == null) {
            throw new IllegalStateException("can not find servlet context.");
        }
        try {
            return Objects.requireNonNull(WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc)).getBeansOfType(cls);
        }
        catch (BeansException e) {
            return Collections.emptyMap();
        }
    }

    public static String getAbsolutePathInWeb(String path) {
        return Objects.requireNonNull(((WebApplicationContext)applicationContext).getServletContext()).getRealPath(path);
    }

    public static Resource getResource(String location) {
        return applicationContext.getResource(location);
    }

    public static Environment getEnvironment() {
        return applicationContext.getEnvironment();
    }

    public static String getProperty(String propertyKey) {
        return SpringUtils.getEnvironment().getProperty(propertyKey);
    }

    public static String getProperty(String propertyKey, String defaultValue) {
        return SpringUtils.getEnvironment().getProperty(propertyKey, defaultValue);
    }

    public static <T> T getAopProxy(T invoker) {
        return (T)AopContext.currentProxy();
    }

    public static void setBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        SpringUtils.beanFactory = beanFactory;
    }

    public static ConfigurableListableBeanFactory getBeanFactory() throws IllegalStateException {
        ConfigurableListableBeanFactory tmp = beanFactory;
        if (tmp == null) {
            throw new IllegalStateException("beanFactory has not set!");
        }
        return tmp;
    }

    public static void setApplicationContext(ApplicationContext applicationContext) {
        SpringUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() throws IllegalStateException {
        ApplicationContext tmp = applicationContext;
        if (tmp == null) {
            throw new IllegalStateException("applicationContext has not set!");
        }
        return tmp;
    }
}

