/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import java.time.Duration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.shoulder.core.delay.DelayTask;
import org.shoulder.core.delay.DelayTaskHolder;
import org.shoulder.core.log.Logger;
import org.shoulder.core.log.LoggerFactory;

public class Threads {
    private static final Logger log = LoggerFactory.getLogger(Threads.class);
    public static final String DEFAULT_THREAD_POOL_NAME = "shoulderThreadPool";
    private static ExecutorService DEFAULT_THREAD_POOL;
    private static DelayTaskHolder DELAY_TASK_HOLDER;

    public static void setExecutorService(ExecutorService executorService) {
        DEFAULT_THREAD_POOL = executorService;
        log.info("Threads' DEFAULT_THREAD_POOL has changed to " + executorService);
    }

    public static void setDelayTaskHolder(DelayTaskHolder delayTaskHolder) {
        DELAY_TASK_HOLDER = delayTaskHolder;
        log.info("Threads' DELAY_TASK_HOLDER has changed to " + delayTaskHolder);
    }

    public static void delay(Runnable runnable, long time, TimeUnit unit) {
        DelayTask task = new DelayTask(runnable, time, unit);
        Threads.delay(task);
    }

    public static void delay(DelayTask delayTask) {
        if (DELAY_TASK_HOLDER == null) {
            throw new IllegalStateException("You must setDelayTaskHolder first.");
        }
        DELAY_TASK_HOLDER.put(delayTask);
    }

    public static void execute(Runnable runnable) {
        if (DEFAULT_THREAD_POOL == null) {
            throw new IllegalStateException("You must setExecutorService first.");
        }
        DEFAULT_THREAD_POOL.execute(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        if (DEFAULT_THREAD_POOL == null) {
            throw new IllegalStateException("You must setExecutorService first.");
        }
        return DEFAULT_THREAD_POOL.submit(callable);
    }

    public static class Block
    implements RejectedExecutionHandler {
        private static final Logger log = LoggerFactory.getLogger(Abort.class);
        private final Duration maxWait;

        public Block(Duration maxWait) {
            this.maxWait = maxWait;
        }

        public Block() {
            this.maxWait = null;
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (executor.isShutdown()) {
                throw new RejectedExecutionException("Executor has been shut down");
            }
            try {
                BlockingQueue<Runnable> queue = executor.getQueue();
                if (this.maxWait == null) {
                    log.debug("Attempting to queue task execution till success, blocking...");
                    queue.put(r);
                } else {
                    log.debug("Attempting to queue task execution, maxWait: {}", this.maxWait);
                    if (!queue.offer(r, this.maxWait.toNanos(), TimeUnit.NANOSECONDS)) {
                        throw new RejectedExecutionException("Max wait time expired to queue task");
                    }
                }
                log.debug("Task execution queued");
            }
            catch (InterruptedException e) {
                log.debug("Interrupted while queuing task execution");
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Interrupted", e);
            }
        }
    }

    public static class Abort
    implements RejectedExecutionHandler {
        private static final Logger log = LoggerFactory.getLogger(Abort.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            throw new RejectedExecutionException("Discard for the executor's queue is full. Task(" + r.toString() + "), Executor({" + executor.toString() + "})");
        }
    }

    public static class DiscardOldest
    implements RejectedExecutionHandler {
        private static final Logger log = LoggerFactory.getLogger(DiscardOldest.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown() && r instanceof FutureTask) {
                ((FutureTask)r).cancel(true);
            }
            log.warn("Discard for the executor's queue is full. Task({}), Executor({})", r.toString(), executor.toString());
        }
    }

    public static class Discard
    implements RejectedExecutionHandler {
        private static final Logger log = LoggerFactory.getLogger(Discard.class);

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            if (!executor.isShutdown() && r instanceof FutureTask) {
                ((FutureTask)r).cancel(true);
            }
            log.warn("Discard for the executor's queue is full. Task({}), Executor({})", r.toString(), executor.toString());
        }
    }
}

