/*
 * Decompiled with CFR 0.152.
 */
package org.shoulder.core.util;

import cn.hutool.core.map.MapUtil;
import java.util.HashMap;
import java.util.Map;

public class TrieTree<V> {
    private TrieNode<V> root = new TrieNode<Object>('\u0000', null);

    public V query(String str) {
        TrieNode<V> cur = this.root;
        for (int i = 0; i < str.length(); ++i) {
            TrieNode<V> child = cur.getNodeMap().get(Character.valueOf(str.charAt(i)));
            if (child == null) {
                return null;
            }
            cur = child;
        }
        return cur.getValue();
    }

    public void put(String str, V value) {
        TrieNode<V> cur = this.root;
        for (int i = 0; i < str.length(); ++i) {
            TrieNode<V> child = cur.getNodeMap().get(Character.valueOf(str.charAt(i)));
            if (child == null) {
                TrieNode<Object> node = new TrieNode<Object>(str.charAt(i), null);
                cur.getNodeMap().put(Character.valueOf(str.charAt(i)), node);
                cur = cur.getNodeMap().get(Character.valueOf(str.charAt(i)));
                continue;
            }
            cur = child;
        }
        cur.setValue(value);
    }

    public boolean exist(String str) {
        TrieNode<V> cur = this.root;
        for (int i = 0; i < str.length(); ++i) {
            TrieNode<V> child = cur.getNodeMap().get(Character.valueOf(str.charAt(i)));
            if (child == null) {
                return false;
            }
            cur = child;
        }
        return true;
    }

    public void remove(String str) {
        if (!this.exist(str)) {
            return;
        }
        TrieNode<Object> cur = this.root;
        TrieNode<Object> delPreNode = this.root;
        char delch = str.charAt(0);
        for (int i = 0; i < str.length(); ++i) {
            TrieNode child = cur.nodeMap.get(Character.valueOf(str.charAt(i)));
            if (MapUtil.isEmpty(child.getNodeMap())) {
                return;
            }
            if (i < str.length() - 1 && child.nodeMap.get(Character.valueOf(str.charAt(i + 1))) != null && child.nodeMap.size() > 0) {
                delPreNode = child;
                delch = str.charAt(i + 1);
            }
            cur = child;
        }
        if (cur.nodeMap.size() > 0) {
            cur.setValue(null);
        } else {
            cur.getNodeMap().remove(Character.valueOf(delch));
        }
    }

    static class TrieNode<VALUE> {
        private char ch;
        private VALUE value;
        private Map<Character, TrieNode<VALUE>> nodeMap;

        public TrieNode(char ch, VALUE value) {
            this.ch = ch;
            this.value = value;
            this.nodeMap = new HashMap<Character, TrieNode<VALUE>>();
        }

        public char getCh() {
            return this.ch;
        }

        public void setCh(char ch) {
            this.ch = ch;
        }

        public VALUE getValue() {
            return this.value;
        }

        public void setValue(VALUE value) {
            this.value = value;
        }

        public Map<Character, TrieNode<VALUE>> getNodeMap() {
            return this.nodeMap;
        }

        public void setNodeMap(Map<Character, TrieNode<VALUE>> nodeMap) {
            this.nodeMap = nodeMap;
        }
    }
}

