/*
 * Decompiled with CFR 0.152.
 */
package cn.jimmyshi.beanquery.selectors;

import cn.jimmyshi.beanquery.selectors.CompositeSelector;
import cn.jimmyshi.beanquery.selectors.KeyValueMapSelector;
import cn.jimmyshi.beanquery.selectors.PropertySelector;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSelector
extends KeyValueMapSelector {
    private transient Logger logger = LoggerFactory.getLogger(StringSelector.class);
    private CompositeSelector compositeSelector = new CompositeSelector();

    public StringSelector(String selectString) {
        this.logger.info("Constructing StringSelector with String [{}]", (Object)selectString);
        if (StringUtils.isBlank((CharSequence)selectString)) {
            this.logger.info("Constructing StringSelector with blank selectString");
            return;
        }
        String[] propertyStrings = StringUtils.split((String)selectString, (char)',');
        this.initCompositeSelector(propertyStrings);
    }

    public StringSelector(String ... propertyStrings) {
        this.logger.info("Construct StringSelector with propertyStrings [{}]", (Object)propertyStrings);
        this.initCompositeSelector(propertyStrings);
    }

    private void initCompositeSelector(String[] propertyStrings) {
        if (ArrayUtils.isEmpty((Object[])propertyStrings)) {
            this.logger.debug("Initing StringSelector with empty property String.");
            return;
        }
        for (String propertyString : propertyStrings) {
            if (!StringUtils.isNotBlank((CharSequence)propertyString)) continue;
            PropertySelector propertySelector = this.createPropertySelector(propertyString);
            this.compositeSelector.addSubSelector(propertySelector);
        }
        this.logger.info("StringSelector [{}] initilized.", (Object)this);
    }

    private PropertySelector createPropertySelector(String propertyString) {
        PropertySelector propertySelector;
        String[] propertyTokens = StringUtils.splitByWholeSeparator((String)propertyString, (String)" as ", (int)2);
        String propertySelectorPropertyName = propertyTokens[0].trim();
        if (propertyTokens.length == 2) {
            String propertySelectorAlias = propertyTokens[1].trim();
            propertySelector = new PropertySelector(propertySelectorPropertyName, propertySelectorAlias);
        } else {
            propertySelector = new PropertySelector(propertySelectorPropertyName);
        }
        return propertySelector;
    }

    @Override
    protected Map<String, Object> doSelect(Object item) {
        return this.compositeSelector.select(item);
    }
}

