/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.pool;

import ai.djl.inference.Predictor;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.pool.PredictorFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class ModelPredictorPoolManager {
    private final Map<String, GenericObjectPool<? extends Predictor<?, ?>>> poolMap = new ConcurrentHashMap();

    public <I, O> void registerModel(String key, ZooModel<I, O> model, GenericObjectPoolConfig<Predictor<I, O>> config) {
        PredictorFactory<I, O> factory = new PredictorFactory<I, O>(model);
        GenericObjectPool pool = new GenericObjectPool(factory, config);
        this.poolMap.put(key, pool);
    }

    public <I, O> Predictor<I, O> borrowPredictor(String key) throws Exception {
        GenericObjectPool<? extends Predictor<?, ?>> pool = this.poolMap.get(key);
        if (pool == null) {
            throw new IllegalArgumentException("\u6a21\u578b\u672a\u6ce8\u518c: " + key);
        }
        return (Predictor)pool.borrowObject();
    }

    public <I, O> void returnPredictor(String key, Predictor<I, O> predictor) {
        GenericObjectPool<? extends Predictor<?, ?>> pool = this.poolMap.get(key);
        if (pool != null) {
            pool.returnObject(predictor);
        }
    }

    public void closeAll() {
        for (GenericObjectPool<? extends Predictor<?, ?>> genericObjectPool : this.poolMap.values()) {
            genericObjectPool.close();
        }
        this.poolMap.clear();
    }
}

