/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.utils;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.ndarray.NDArray;
import cn.smartjavaai.common.entity.DetectionRectangle;
import cn.smartjavaai.common.utils.OpenCVUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.imgproc.Imgproc;

public class ImageUtils {
    private static boolean equalBandOffsetWith3Byte(BufferedImage image, int[] bandOffset) {
        ComponentSampleModel sampleModel;
        return image.getType() == 5 && image.getData().getSampleModel() instanceof ComponentSampleModel && Arrays.equals((sampleModel = (ComponentSampleModel)image.getData().getSampleModel()).getBandOffsets(), bandOffset);
    }

    public static boolean isBGR3Byte(BufferedImage image) {
        return ImageUtils.equalBandOffsetWith3Byte(image, new int[]{0, 1, 2});
    }

    public static byte[] getMatrixBGR(BufferedImage image) {
        byte[] matrixBGR;
        if (ImageUtils.isBGR3Byte(image)) {
            matrixBGR = (byte[])image.getData().getDataElements(0, 0, image.getWidth(), image.getHeight(), null);
        } else {
            int[] intrgb = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
            matrixBGR = new byte[image.getWidth() * image.getHeight() * 3];
            int i = 0;
            int j = 0;
            while (i < intrgb.length) {
                matrixBGR[j] = (byte)(intrgb[i] & 0xFF);
                matrixBGR[j + 1] = (byte)(intrgb[i] >> 8 & 0xFF);
                matrixBGR[j + 2] = (byte)(intrgb[i] >> 16 & 0xFF);
                ++i;
                j += 3;
            }
        }
        return matrixBGR;
    }

    public static BufferedImage bgrToBufferedImage(byte[] data, int width, int height) {
        int type = 5;
        for (int i = 0; i < data.length; i += 3) {
            byte b = data[i];
            data[i] = data[i + 2];
            data[i + 2] = b;
        }
        BufferedImage image = new BufferedImage(width, height, type);
        image.getRaster().setDataElements(0, 0, width, height, data);
        return image;
    }

    public static boolean isImageValid(BufferedImage image) {
        return image != null && image.getWidth() > 0 && image.getHeight() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageRect(BufferedImage image, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)image.getGraphics();
        try {
            g.setColor(new Color(0, 255, 0));
            BasicStroke bStroke = new BasicStroke(2.0f, 0, 0);
            g.setStroke(bStroke);
            g.drawRect(x, y, width, height);
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageRect(Image image, int x, int y, int width, int height) {
        BufferedImage bufferedImage = (BufferedImage)image.getWrappedImage();
        Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
        try {
            g.setColor(new Color(0, 255, 0));
            BasicStroke bStroke = new BasicStroke(2.0f, 0, 0);
            g.setStroke(bStroke);
            g.drawRect(x, y, width, height);
        }
        finally {
            g.dispose();
        }
    }

    public static void saveImage(BufferedImage img, String name, String path) {
        Mat mat = OpenCVUtils.image2Mat(img);
        Image djlImg = ImageFactory.getInstance().fromImage((Object)mat);
        Path outputDir = Paths.get(path, new String[0]);
        Path imagePath = outputDir.resolve(name);
        try {
            djlImg.save(Files.newOutputStream(imagePath, new OpenOption[0]), "png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mat.release();
    }

    public static void saveImage(BufferedImage img, String path) {
        Mat mat = OpenCVUtils.image2Mat(img);
        Image djlImg = ImageFactory.getInstance().fromImage((Object)mat);
        Path outputDir = Paths.get(path, new String[0]);
        try {
            djlImg.save(Files.newOutputStream(outputDir, new OpenOption[0]), "png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mat.release();
    }

    public static void saveImage(Image img, String name, String path) {
        Path outputDir = Paths.get(path, new String[0]);
        Path imagePath = outputDir.resolve(name);
        try {
            img.save(Files.newOutputStream(imagePath, new OpenOption[0]), "png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveBoundingBoxImage(Image img, DetectedObjects detection, String name, String path) throws IOException {
        img.drawBoundingBoxes(detection);
        Path outputDir = Paths.get(path, new String[0]);
        Files.createDirectories(outputDir, new FileAttribute[0]);
        Path imagePath = outputDir.resolve(name);
        img.save(Files.newOutputStream(imagePath, new OpenOption[0]), "png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageRect(BufferedImage image, NDArray box) {
        float[] points = box.toFloatArray();
        int[] xPoints = new int[5];
        int[] yPoints = new int[5];
        for (int i = 0; i < 4; ++i) {
            xPoints[i] = (int)points[2 * i];
            yPoints[i] = (int)points[2 * i + 1];
        }
        xPoints[4] = xPoints[0];
        yPoints[4] = yPoints[0];
        Graphics2D g = (Graphics2D)image.getGraphics();
        try {
            g.setColor(new Color(0, 255, 0));
            BasicStroke bStroke = new BasicStroke(4.0f, 0, 0);
            g.setStroke(bStroke);
            g.drawPolyline(xPoints, yPoints, 5);
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageRectWithText(BufferedImage image, NDArray box, String text) {
        float[] points = box.toFloatArray();
        int[] xPoints = new int[5];
        int[] yPoints = new int[5];
        for (int i = 0; i < 4; ++i) {
            xPoints[i] = (int)points[2 * i];
            yPoints[i] = (int)points[2 * i + 1];
        }
        xPoints[4] = xPoints[0];
        yPoints[4] = yPoints[0];
        Graphics2D g = (Graphics2D)image.getGraphics();
        try {
            int fontSize = 32;
            Font font = new Font("\u6977\u4f53", 0, fontSize);
            g.setFont(font);
            g.setColor(new Color(0, 0, 255));
            BasicStroke bStroke = new BasicStroke(2.0f, 0, 0);
            g.setStroke(bStroke);
            g.drawPolyline(xPoints, yPoints, 5);
            g.drawString(text, xPoints[0], yPoints[0]);
        }
        finally {
            g.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageText(BufferedImage image, String text, int x, int y) {
        Graphics graphics = image.getGraphics();
        int fontSize = 32;
        Font font = new Font("\u6977\u4f53", 0, fontSize);
        try {
            graphics.setFont(font);
            graphics.setColor(new Color(0, 0, 255));
            int strWidth = graphics.getFontMetrics().stringWidth(text);
            graphics.drawString(text, x, y);
        }
        finally {
            graphics.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawImageRectWithText(BufferedImage image, DetectionRectangle box, String text, Color color) {
        Graphics2D graphics = (Graphics2D)image.getGraphics();
        try {
            graphics.setColor(Color.RED);
            graphics.setStroke(new BasicStroke(2.0f));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int stroke = 2;
            graphics.setColor(color);
            graphics.drawRect(box.getX(), box.getY(), box.getWidth(), box.getHeight());
            ImageUtils.drawText(graphics, text, box.getX(), box.getY(), stroke, 4);
            graphics.dispose();
        }
        finally {
            graphics.dispose();
        }
    }

    public static void drawText(Graphics2D g, String text, int x, int y, int stroke, int padding) {
        FontMetrics metrics = g.getFontMetrics();
        x += stroke / 2;
        y += stroke / 2;
        int width = metrics.stringWidth(text) + padding * 2 - stroke / 2;
        int height = metrics.getHeight() + metrics.getDescent();
        int ascent = metrics.getAscent();
        y = Math.max(0, y - height);
        Rectangle background = new Rectangle(x, y, width, height);
        g.fill(background);
        g.setPaint(Color.WHITE);
        g.drawString(text, x + padding, y + ascent);
    }

    public static int[] rectXYXY(ai.djl.modality.cv.output.Rectangle rect, int width, int height) {
        int left = Math.max((int)((double)width * rect.getX()), 0);
        int top = Math.max((int)((double)height * rect.getY()), 0);
        int right = Math.min((int)((double)width * (rect.getX() + rect.getWidth())), width - 1);
        int bottom = Math.min((int)((double)height * (rect.getY() + rect.getHeight())), height - 1);
        return new int[]{left, top, right, bottom};
    }

    public static List<File> listImageFiles(String folderPath) {
        File folder = new File(folderPath);
        ArrayList<File> imageFiles = new ArrayList<File>();
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files == null) {
                return imageFiles;
            }
            for (File file : files) {
                String name;
                if (!file.isFile() || !(name = file.getName().toLowerCase()).endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".png") && !name.endsWith(".bmp") && !name.endsWith(".gif") && !name.endsWith(".tiff") && !name.endsWith(".webp")) continue;
                imageFiles.add(file);
            }
        }
        return imageFiles;
    }

    public static List<Image> readImagesFromFolder(String folderPath) throws IOException {
        File folder = new File(folderPath);
        ArrayList<Image> imageList = new ArrayList<Image>();
        if (folder.exists() && folder.isDirectory()) {
            File[] files = folder.listFiles();
            if (files == null) {
                return imageList;
            }
            for (File file : files) {
                String name;
                if (!file.isFile() || !(name = file.getName().toLowerCase()).endsWith(".jpg") && !name.endsWith(".jpeg") && !name.endsWith(".png") && !name.endsWith(".bmp") && !name.endsWith(".gif") && !name.endsWith(".tiff") && !name.endsWith(".webp")) continue;
                Image img = ImageFactory.getInstance().fromInputStream(Files.newInputStream(file.toPath(), new OpenOption[0]));
                imageList.add(img);
            }
        }
        return imageList;
    }

    public static boolean isAllImageSizeEqual(List<Image> images) {
        if (images == null || images.isEmpty()) {
            return true;
        }
        int width = images.get(0).getWidth();
        int height = images.get(0).getHeight();
        for (Image img : images) {
            if (img.getWidth() == width && img.getHeight() == height) continue;
            return false;
        }
        return true;
    }

    public static void putTextWithBackground(Mat image, String text, Point origin, Scalar textColor, Scalar backgroundColor, int padding) {
        int font = 6;
        double fontScale = 1.0;
        int thickness = 2;
        int[] baseLine = new int[1];
        Size textSize = Imgproc.getTextSize((String)text, (int)font, (double)fontScale, (int)thickness, (int[])baseLine);
        int textWidth = (int)textSize.width;
        int textHeight = (int)textSize.height;
        Point bgTopLeft = new Point(origin.x - (double)padding, origin.y - (double)textHeight - (double)padding);
        Point bgBottomRight = new Point(origin.x + (double)textWidth + (double)padding, origin.y + (double)baseLine[0] + (double)padding);
        Imgproc.rectangle((Mat)image, (Point)bgTopLeft, (Point)bgBottomRight, (Scalar)backgroundColor, (int)-1);
        Imgproc.putText((Mat)image, (String)text, (Point)origin, (int)font, (double)fontScale, (Scalar)textColor, (int)thickness);
    }
}

