/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.common.utils;

import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;

public class LetterBoxUtils {
    public static ResizeResult letterboxWithMeta(NDArray paddingImg, float r, int left, int top) {
        ResizeResult result = new ResizeResult();
        result.image = paddingImg;
        result.r = r;
        result.left = left;
        result.top = top;
        return result;
    }

    public static ResizeResult letterbox(NDManager manager, NDArray img, int targetW, int targetH, float padColor, PaddingPosition position) {
        long origH = img.getShape().get(0);
        long origW = img.getShape().get(1);
        float r = Math.min((float)targetW / (float)origW, (float)targetH / (float)origH);
        int newW = Math.round((float)origW * r);
        int newH = Math.round((float)origH * r);
        img = NDImageUtils.resize((NDArray)img, (int)newW, (int)newH);
        NDArray paddingImg = manager.zeros(new Shape(new long[]{targetW, targetH, 3L}), DataType.FLOAT32);
        paddingImg = paddingImg.add((Number)114);
        int padW = targetW - newW;
        int padH = targetH - newH;
        int top = 0;
        int left = 0;
        switch (position) {
            case CENTER: {
                left = padW / 2;
                top = padH / 2;
                break;
            }
            case LEFT_TOP: {
                left = 0;
                top = 0;
                break;
            }
            case RIGHT_BOTTOM: {
                left = padW;
                top = padH;
            }
        }
        paddingImg.set(new NDIndex(String.format("%d:%d,%d:%d", top, top + newH, left, left + newW), new Object[0]), img);
        return LetterBoxUtils.letterboxWithMeta(paddingImg, r, left, top);
    }

    public static NDArray restoreBox(NDArray boxes, float scaleRatio, float left, float top, int keypointStart, int keypointDim) {
        NDArray x1 = boxes.get(":, 0", new Object[0]).sub((Number)Float.valueOf(left)).div((Number)Float.valueOf(scaleRatio));
        NDArray y1 = boxes.get(":, 1", new Object[0]).sub((Number)Float.valueOf(top)).div((Number)Float.valueOf(scaleRatio));
        NDArray x2 = boxes.get(":, 2", new Object[0]).sub((Number)Float.valueOf(left)).div((Number)Float.valueOf(scaleRatio));
        NDArray y2 = boxes.get(":, 3", new Object[0]).sub((Number)Float.valueOf(top)).div((Number)Float.valueOf(scaleRatio));
        boxes.set(new NDIndex(":, 0", new Object[0]), x1);
        boxes.set(new NDIndex(":, 1", new Object[0]), y1);
        boxes.set(new NDIndex(":, 2", new Object[0]), x2);
        boxes.set(new NDIndex(":, 3", new Object[0]), y2);
        if (keypointDim > 0) {
            for (int i = 0; i < keypointDim; i += 2) {
                int xIdx = keypointStart + i;
                int yIdx = keypointStart + i + 1;
                NDArray keyX = boxes.get(":, " + xIdx, new Object[0]).sub((Number)Float.valueOf(left)).div((Number)Float.valueOf(scaleRatio));
                NDArray keyY = boxes.get(":, " + yIdx, new Object[0]).sub((Number)Float.valueOf(top)).div((Number)Float.valueOf(scaleRatio));
                boxes.set(new NDIndex(":, " + xIdx, new Object[0]), keyX);
                boxes.set(new NDIndex(":, " + yIdx, new Object[0]), keyY);
            }
        }
        return boxes;
    }

    public static class ResizeResult {
        public NDArray image;
        public float r;
        public int left;
        public int top;
    }

    public static enum PaddingPosition {
        CENTER,
        LEFT_TOP,
        RIGHT_BOTTOM;

    }
}

