/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.FaceDetConfig;
import cn.smartjavaai.face.enums.FaceDetModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.facedect.CommonFaceDetModel;
import cn.smartjavaai.face.model.facedect.FaceDetModel;
import cn.smartjavaai.face.model.facedect.SeetaFace6FaceDetModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FaceDetModelFactory {
    private static final Logger log = LoggerFactory.getLogger(FaceDetModelFactory.class);
    private static volatile FaceDetModelFactory instance;
    private static final ConcurrentHashMap<String, FaceDetModel> modelMap;
    private static final Map<String, Class<? extends FaceDetModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FaceDetModelFactory getInstance() {
        if (instance != null) return instance;
        Class<FaceDetModelFactory> clazz = FaceDetModelFactory.class;
        synchronized (FaceDetModelFactory.class) {
            if (instance != null) return instance;
            instance = new FaceDetModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerAlgorithm(String name, Class<? extends FaceDetModel> clazz) {
        registry.put(name.toLowerCase(), clazz);
    }

    public FaceDetModel getModel(FaceDetConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u4eba\u8138\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum().name(), k -> this.createFaceDetModel(config));
    }

    public FaceDetModel getModel() {
        FaceDetConfig config = new FaceDetConfig();
        config.setModelEnum(FaceDetModelEnum.RETINA_FACE);
        config.setConfidenceThreshold(0.85f);
        config.setNmsThresh(0.45f);
        return this.getModel(config);
    }

    private FaceDetModel createFaceDetModel(FaceDetConfig config) {
        Class<? extends FaceDetModel> clazz = registry.get(config.getModelEnum().getModelClassName().toLowerCase());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        FaceDetModel algorithm = null;
        try {
            algorithm = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        algorithm.loadModel(config);
        return algorithm;
    }

    public FaceDetModel getLightFaceDetModel() {
        FaceDetConfig config = new FaceDetConfig();
        config.setModelEnum(FaceDetModelEnum.ULTRA_LIGHT_FAST_GENERIC_FACE);
        config.setConfidenceThreshold(0.85f);
        config.setNmsThresh(0.45f);
        return this.getModel(config);
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<String, Class<? extends FaceDetModel>>();
        FaceDetModelFactory.registerAlgorithm("retinafacemodel", CommonFaceDetModel.class);
        FaceDetModelFactory.registerAlgorithm("ultralightfastgenericfacemodel", CommonFaceDetModel.class);
        FaceDetModelFactory.registerAlgorithm("seetaface6model", SeetaFace6FaceDetModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

