/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.face.config.LivenessConfig;
import cn.smartjavaai.face.enums.LivenessModelEnum;
import cn.smartjavaai.face.exception.FaceException;
import cn.smartjavaai.face.model.liveness.CommonLivenessModel;
import cn.smartjavaai.face.model.liveness.LivenessDetModel;
import cn.smartjavaai.face.model.liveness.MiniVisionLivenessModel;
import cn.smartjavaai.face.model.liveness.Seetaface6LivenessModel;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LivenessModelFactory {
    private static final Logger log = LoggerFactory.getLogger(LivenessModelFactory.class);
    private static volatile LivenessModelFactory instance;
    private static final ConcurrentHashMap<LivenessModelEnum, LivenessDetModel> modelMap;
    private static final Map<LivenessModelEnum, Class<? extends LivenessDetModel>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LivenessModelFactory getInstance() {
        if (instance != null) return instance;
        Class<LivenessModelFactory> clazz = LivenessModelFactory.class;
        synchronized (LivenessModelFactory.class) {
            if (instance != null) return instance;
            instance = new LivenessModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(LivenessModelEnum livenessModelEnum, Class<? extends LivenessDetModel> clazz) {
        registry.put(livenessModelEnum, clazz);
    }

    public LivenessDetModel getModel(LivenessConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new FaceException("\u672a\u914d\u7f6e\u6d3b\u4f53\u68c0\u6d4b\u6a21\u578b");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private LivenessDetModel createFaceModel(LivenessConfig config) {
        Class<? extends LivenessDetModel> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new FaceException("Unsupported algorithm");
        }
        LivenessDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new FaceException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<LivenessModelEnum, Class<? extends LivenessDetModel>>();
        LivenessModelFactory.registerModel(LivenessModelEnum.SEETA_FACE6_MODEL, Seetaface6LivenessModel.class);
        LivenessModelFactory.registerModel(LivenessModelEnum.MINI_VISION_MODEL, MiniVisionLivenessModel.class);
        LivenessModelFactory.registerModel(LivenessModelEnum.IIC_FL_MODEL, CommonLivenessModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

