/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.model.expression.translator;

import ai.djl.modality.Classifications;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.Arrays;
import java.util.List;

public class FrEmotionTranslator
implements Translator<Image, Classifications> {
    private final List<String> labels = Arrays.asList("angry", "disgust", "fear", "happy", "sad", "surprise", "neutral");
    private int imageSize = 224;

    public FrEmotionTranslator(int imageSize) {
        this.imageSize = imageSize;
    }

    public Classifications processOutput(TranslatorContext ctx, NDList list) {
        NDArray output = list.singletonOrThrow();
        output = output.softmax(1);
        return new Classifications(this.labels, output);
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager(), Image.Flag.COLOR);
        Shape shape = array.getShape();
        long height = shape.get(0);
        long width = shape.get(1);
        if (height != (long)this.imageSize || width != (long)this.imageSize) {
            array = NDImageUtils.resize((NDArray)array, (int)this.imageSize, (int)this.imageSize);
        }
        array = array.transpose(new int[]{2, 0, 1});
        array = array.expandDims(0);
        array = array.toType(DataType.FLOAT32, false).div((Number)Float.valueOf(255.0f));
        return new NDList(new NDArray[]{array});
    }

    public Batchifier getBatchifier() {
        return null;
    }
}

