/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.face.vector.core;

import cn.smartjavaai.common.entity.face.FaceSearchResult;
import cn.smartjavaai.face.entity.FaceSearchParams;
import cn.smartjavaai.face.enums.IdStrategy;
import cn.smartjavaai.face.utils.FaceUtils;
import cn.smartjavaai.face.vector.config.MilvusConfig;
import cn.smartjavaai.face.vector.core.VectorDBClient;
import cn.smartjavaai.face.vector.entity.FaceVector;
import cn.smartjavaai.face.vector.exception.VectorDBException;
import io.milvus.client.MilvusServiceClient;
import io.milvus.grpc.DataType;
import io.milvus.grpc.DescribeCollectionResponse;
import io.milvus.grpc.FieldData;
import io.milvus.grpc.MutationResult;
import io.milvus.grpc.QueryResults;
import io.milvus.grpc.SearchResults;
import io.milvus.param.ConnectParam;
import io.milvus.param.IndexType;
import io.milvus.param.R;
import io.milvus.param.collection.CreateCollectionParam;
import io.milvus.param.collection.DescribeCollectionParam;
import io.milvus.param.collection.DropCollectionParam;
import io.milvus.param.collection.FieldType;
import io.milvus.param.collection.HasCollectionParam;
import io.milvus.param.collection.LoadCollectionParam;
import io.milvus.param.collection.ReleaseCollectionParam;
import io.milvus.param.dml.DeleteParam;
import io.milvus.param.dml.InsertParam;
import io.milvus.param.dml.QueryParam;
import io.milvus.param.dml.SearchParam;
import io.milvus.param.dml.UpsertParam;
import io.milvus.param.index.CreateIndexParam;
import io.milvus.response.DescCollResponseWrapper;
import io.milvus.response.QueryResultsWrapper;
import io.milvus.response.SearchResultsWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MilvusClient
implements VectorDBClient {
    private static final Logger log = LoggerFactory.getLogger(MilvusClient.class);
    private final MilvusConfig config;
    private MilvusServiceClient serviceClient;
    private String collectionName;
    private boolean isInit;

    public MilvusClient(MilvusConfig config) {
        this.config = config;
    }

    @Override
    public void initialize() {
        try {
            ConnectParam.Builder builder = ConnectParam.newBuilder().withHost(this.config.getHost()).withPort(this.config.getPort());
            if (StringUtils.isNotBlank((CharSequence)this.config.getUsername()) && StringUtils.isNotBlank((CharSequence)this.config.getPassword())) {
                builder.withAuthorization(this.config.getUsername(), this.config.getPassword());
            }
            ConnectParam connectParam = builder.build();
            this.serviceClient = new MilvusServiceClient(connectParam);
            this.collectionName = StringUtils.isNotBlank((CharSequence)this.config.getCollectionName()) ? this.config.getCollectionName() : "face";
            this.createCollection(this.collectionName, this.config.getDimension());
            boolean isAutoID = this.isAutoID(this.collectionName);
            if (isAutoID && this.config.getIdStrategy() != IdStrategy.AUTO) {
                throw new VectorDBException("ID\u7b56\u7565\u4e0e\u5f53\u524dCollection\u4e0d\u5339\u914d");
            }
            if (!isAutoID && this.config.getIdStrategy() == IdStrategy.AUTO) {
                throw new VectorDBException("ID\u7b56\u7565\u4e0e\u5f53\u524dCollection\u4e0d\u5339\u914d");
            }
            if (this.config.isUseMemoryCache()) {
                this.loadFaceFeatures();
            }
            this.isInit = true;
        }
        catch (Exception e) {
            throw new VectorDBException("\u521d\u59cb\u5316Milvus\u5ba2\u6237\u7aef\u5931\u8d25", e);
        }
    }

    @Override
    public void createCollection(String collectionName, int dimension) {
        try {
            CreateIndexParam indexParam;
            R createIndexResponse;
            if (this.hasCollection(collectionName)) {
                log.debug("\u96c6\u5408\u5df2\u5b58\u5728:{}", (Object)collectionName);
                return;
            }
            FieldType idField = null;
            switch (this.config.getIdStrategy()) {
                case AUTO: {
                    idField = FieldType.newBuilder().withName("id").withDataType(DataType.Int64).withPrimaryKey(true).withAutoID(true).build();
                    break;
                }
                case CUSTOM: {
                    idField = FieldType.newBuilder().withName("id").withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(36)).withPrimaryKey(true).withAutoID(false).build();
                }
            }
            FieldType vectorField = FieldType.newBuilder().withName("vector").withDataType(DataType.FloatVector).withDimension(Integer.valueOf(dimension)).build();
            FieldType metadataField = FieldType.newBuilder().withName("metadata").withDataType(DataType.VarChar).withMaxLength(Integer.valueOf(32768)).withNullable(true).build();
            CreateCollectionParam createCollectionParam = CreateCollectionParam.newBuilder().withCollectionName(collectionName).withDescription("\u4eba\u8138\u7279\u5f81\u5411\u91cf\u96c6\u5408").addFieldType(idField).addFieldType(vectorField).addFieldType(metadataField).build();
            R response = this.serviceClient.createCollection(createCollectionParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Milvus \u521b\u5efa\u96c6\u5408\u5931\u8d25\uff1a" + response.getMessage());
            }
            log.debug("\u521b\u5efa\u96c6\u5408\u6210\u529f");
            IndexType indexType = IndexType.IVF_FLAT;
            if (this.config.getIndexType() != null) {
                indexType = this.config.getIndexType();
            }
            if ((createIndexResponse = this.serviceClient.createIndex(indexParam = CreateIndexParam.newBuilder().withCollectionName(collectionName).withFieldName("vector").withIndexType(indexType).withMetricType(this.config.getMetricType()).withExtraParam(String.format("{\"nlist\":%d}", this.config.getNlist())).withSyncMode(Boolean.TRUE).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Milvus \u521b\u5efa\u7d22\u5f15\u5931\u8d25\uff1a" + createIndexResponse.getMessage());
            }
            log.debug("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
        }
        catch (Exception e) {
            throw new VectorDBException("\u521b\u5efaMilvus\u96c6\u5408\u5931\u8d25", e);
        }
    }

    private boolean isAutoID(String collectionName) {
        R response = this.serviceClient.describeCollection(DescribeCollectionParam.newBuilder().withCollectionName(collectionName).build());
        DescCollResponseWrapper wrapper = new DescCollResponseWrapper((DescribeCollectionResponse)response.getData());
        return wrapper.getPrimaryField().isAutoID();
    }

    @Override
    public void dropCollection(String collectionName) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            if (this.hasCollection(collectionName)) {
                R response = this.serviceClient.dropCollection(DropCollectionParam.newBuilder().withCollectionName(collectionName).build());
                if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                    throw new VectorDBException("Milvus \u5220\u9664\u96c6\u5408\u5931\u8d25\uff1a" + response.getMessage());
                }
                this.isInit = false;
            }
        }
        catch (Exception e) {
            throw new VectorDBException("\u5220\u9664Milvus\u96c6\u5408\u5931\u8d25", e);
        }
    }

    @Override
    public boolean hasCollection(String collectionName) {
        try {
            R response = this.serviceClient.hasCollection(HasCollectionParam.newBuilder().withCollectionName(collectionName).build());
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Milvus \u67e5\u8be2\u5931\u8d25\uff1a" + response.getMessage());
            }
            return Boolean.TRUE.equals(response.getData());
        }
        catch (Exception e) {
            throw new VectorDBException("\u68c0\u67e5Milvus\u96c6\u5408\u662f\u5426\u4fdd\u5b58\u5931\u8d25", e);
        }
    }

    @Override
    public String insert(FaceVector faceVector) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            if (faceVector == null) {
                throw new VectorDBException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1afaceVector\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (faceVector.getVector() == null || faceVector.getVector().length == 0) {
                throw new VectorDBException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1avector\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.config.getIdStrategy() == IdStrategy.CUSTOM && StringUtils.isBlank((CharSequence)faceVector.getId())) {
                throw new VectorDBException("\u63d2\u5165\u6570\u636e\u5931\u8d25\uff1aID\u751f\u6210\u7b56\u7565-\u81ea\u5b9a\u4e49ID\uff0cid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<Float> vectorList = new ArrayList<Float>();
            for (float v : faceVector.getVector()) {
                vectorList.add(Float.valueOf(v));
            }
            List vectors = Collections.singletonList(vectorList);
            List metadataList = Optional.ofNullable(faceVector.getMetadata()).map(Collections::singletonList).orElse(Collections.emptyList());
            List<InsertParam.Field> fields = null;
            switch (this.config.getIdStrategy()) {
                case AUTO: {
                    fields = Arrays.asList(InsertParam.Field.builder().name("vector").values(vectors).build(), InsertParam.Field.builder().name("metadata").values(metadataList).build());
                    break;
                }
                case CUSTOM: {
                    List<String> ids = Collections.singletonList(faceVector.getId());
                    fields = Arrays.asList(InsertParam.Field.builder().name("id").values(ids).build(), InsertParam.Field.builder().name("vector").values(vectors).build(), InsertParam.Field.builder().name("metadata").values(metadataList).build());
                }
            }
            InsertParam insertParam = InsertParam.newBuilder().withCollectionName(this.collectionName).withFields(fields).build();
            R response = this.serviceClient.insert(insertParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("\u63d2\u5165\u5931\u8d25: " + response.getMessage());
            }
            List autoIds = ((MutationResult)response.getData()).getIDs().getIntId().getDataList();
            return this.config.getIdStrategy() == IdStrategy.AUTO ? String.valueOf(autoIds.get(0)) : faceVector.getId();
        }
        catch (Exception e) {
            throw new VectorDBException("\u63d2\u5165Milvus\u5411\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public void upsert(FaceVector faceVector) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            if (this.config.getIdStrategy() == IdStrategy.AUTO) {
                throw new VectorDBException("idStrategy\u4e3aAUTO\u65f6,\u4e0d\u652f\u6301\u66f4\u65b0\u64cd\u4f5c");
            }
            if (faceVector == null) {
                throw new VectorDBException("\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1afaceVector\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (faceVector.getVector() == null || faceVector.getVector().length == 0) {
                throw new VectorDBException("\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1avector\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)faceVector.getId())) {
                throw new VectorDBException("\u66f4\u65b0\u6570\u636e\u5931\u8d25\uff1aid\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ArrayList<Float> vectorList = new ArrayList<Float>();
            for (float v : faceVector.getVector()) {
                vectorList.add(Float.valueOf(v));
            }
            List vectors = Collections.singletonList(vectorList);
            List metadataList = Optional.ofNullable(faceVector.getMetadata()).map(Collections::singletonList).orElse(Collections.emptyList());
            ArrayList<InsertParam.Field> fields = new ArrayList<InsertParam.Field>();
            fields.add(InsertParam.Field.builder().name("id").values(Collections.singletonList(faceVector.getId())).build());
            fields.add(InsertParam.Field.builder().name("vector").values(vectors).build());
            fields.add(InsertParam.Field.builder().name("metadata").values(metadataList).build());
            UpsertParam upsertParam = UpsertParam.newBuilder().withCollectionName(this.collectionName).withFields(fields).build();
            R response = this.serviceClient.upsert(upsertParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Upsert\u64cd\u4f5c\u5931\u8d25: " + response.getMessage());
            }
        }
        catch (Exception e) {
            throw new VectorDBException("Milvus Upsert\u64cd\u4f5c\u5931\u8d25", e);
        }
    }

    @Override
    public List<String> insertBatch(List<FaceVector> faceVectors) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            List<String> ids = faceVectors.stream().map(FaceVector::getId).collect(Collectors.toList());
            ArrayList vectors = new ArrayList();
            for (FaceVector fv : faceVectors) {
                ArrayList<Float> list = new ArrayList<Float>();
                for (float f : fv.getVector()) {
                    list.add(Float.valueOf(f));
                }
                vectors.add(list);
            }
            List metadataList = faceVectors.stream().map(FaceVector::getMetadata).collect(Collectors.toList());
            InsertParam insertParam = InsertParam.newBuilder().withCollectionName(this.collectionName).withFields(Arrays.asList(InsertParam.Field.builder().name("id").values(ids).build(), InsertParam.Field.builder().name("vector").values(vectors).build(), InsertParam.Field.builder().name("metadata").values(metadataList).build())).build();
            R insertResult = this.serviceClient.insert(insertParam);
            return ids;
        }
        catch (Exception e) {
            throw new VectorDBException("\u6279\u91cf\u63d2\u5165Milvus\u5411\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public void delete(String id) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            String expr = String.format("%s == \"%s\"", "id", id);
            DeleteParam deleteParam = DeleteParam.newBuilder().withCollectionName(this.collectionName).withExpr(expr).build();
            R response = this.serviceClient.delete(deleteParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("\u5220\u9664\u64cd\u4f5c\u5931\u8d25: " + response.getMessage());
            }
        }
        catch (Exception e) {
            throw new VectorDBException("\u5220\u9664Milvus\u5411\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public void deleteBatch(List<String> ids) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            StringBuilder expr = new StringBuilder("id in [");
            for (int i = 0; i < ids.size(); ++i) {
                if (this.config.getIdStrategy() == IdStrategy.AUTO) {
                    expr.append(ids.get(i));
                } else {
                    expr.append("'" + ids.get(i) + "'");
                }
                if (i >= ids.size() - 1) continue;
                expr.append(", ");
            }
            expr.append("]");
            DeleteParam deleteParam = DeleteParam.newBuilder().withCollectionName(this.collectionName).withExpr(expr.toString()).build();
            R response = this.serviceClient.delete(deleteParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("\u5220\u9664\u64cd\u4f5c\u5931\u8d25: " + response.getMessage());
            }
        }
        catch (Exception e) {
            throw new VectorDBException("\u6279\u91cf\u5220\u9664Milvus\u5411\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public List<FaceSearchResult> search(float[] queryVector, FaceSearchParams faceSearchParams) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            ArrayList vectors = new ArrayList();
            ArrayList<Float> floatList = new ArrayList<Float>();
            for (float f : queryVector) {
                floatList.add(Float.valueOf(f));
            }
            vectors.add(floatList);
            SearchParam searchParam = SearchParam.newBuilder().withCollectionName(this.collectionName).withVectorFieldName("vector").withTopK(faceSearchParams.getTopK()).withMetricType(this.config.getMetricType()).withOutFields(Arrays.asList("id", "metadata")).withVectors(vectors).withParams("{\"nprobe\": 10}").build();
            R resp = this.serviceClient.search(searchParam);
            if (resp.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Milvus \u67e5\u8be2\u5931\u8d25: " + resp.getMessage());
            }
            SearchResults results = (SearchResults)resp.getData();
            SearchResultsWrapper wrapper = new SearchResultsWrapper(results.getResults());
            List scores = wrapper.getIDScore(0);
            ArrayList<FaceSearchResult> finalResults = new ArrayList<FaceSearchResult>();
            for (int i = 0; i < scores.size(); ++i) {
                SearchResultsWrapper.IDScore score = (SearchResultsWrapper.IDScore)scores.get(i);
                float similarity = score.getScore();
                if (faceSearchParams.getNormalizeSimilarity().booleanValue()) {
                    similarity = FaceUtils.convertScoreToSimilarity(this.config.getMetricType().name(), score.getScore());
                }
                if (!(similarity >= faceSearchParams.getThreshold().floatValue())) continue;
                String metadata = wrapper.getFieldData("metadata", 0).get(i).toString();
                String id = wrapper.getFieldData("id", 0).get(i).toString();
                finalResults.add(new FaceSearchResult(id, similarity, metadata));
            }
            return finalResults;
        }
        catch (Exception e) {
            throw new VectorDBException("\u641c\u7d22 Milvus \u5411\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public long count(String collectionName) {
        try {
            if (this.serviceClient == null) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            R response = this.serviceClient.query(QueryParam.newBuilder().withCollectionName(collectionName).withOutFields(Collections.singletonList("count(*)")).build());
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("Milvus \u67e5\u8be2\u5931\u8d25\uff0cmsg: " + response.getMessage());
            }
            List fields = ((QueryResults)response.getData()).getFieldsDataList();
            if (fields.isEmpty()) {
                throw new VectorDBException("Milvus \u8fd4\u56de\u7a7a\u5b57\u6bb5\u6570\u636e");
            }
            FieldData countField = (FieldData)fields.get(0);
            List countValues = countField.getScalars().getLongData().getDataList();
            if (countValues.isEmpty()) {
                throw new VectorDBException("Milvus count(*) \u8fd4\u56de\u4e3a\u7a7a");
            }
            return (Long)countValues.get(0);
        }
        catch (Exception e) {
            throw new VectorDBException("\u83b7\u53d6 Milvus \u96c6\u5408\u6570\u91cf\u5931\u8d25", e);
        }
    }

    @Override
    public void close() {
        if (this.serviceClient != null) {
            this.serviceClient.close();
            this.isInit = false;
        }
    }

    @Override
    public FaceVector getFaceInfoById(String id) {
        try {
            R response;
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            String expr = "id == '" + id + "'";
            if (this.config.getIdStrategy() == IdStrategy.AUTO) {
                expr = "id == " + id;
            }
            if ((response = this.serviceClient.query(QueryParam.newBuilder().withCollectionName(this.collectionName).withExpr(expr).withOutFields(Arrays.asList("id", "vector", "metadata")).build())).getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("\u67e5\u8be2\u5931\u8d25: " + response.getMessage());
            }
            QueryResultsWrapper wrapper = new QueryResultsWrapper((QueryResults)response.getData());
            List records = wrapper.getRowRecords();
            if (records.isEmpty()) {
                return null;
            }
            QueryResultsWrapper.RowRecord row = (QueryResultsWrapper.RowRecord)records.get(0);
            Object vectorObj = row.get("vector");
            float[] vector = null;
            if (vectorObj instanceof List) {
                List vectorList = (List)vectorObj;
                vector = new float[vectorList.size()];
                for (int i = 0; i < vectorList.size(); ++i) {
                    vector[i] = ((Float)vectorList.get(i)).floatValue();
                }
            }
            return new FaceVector(id, vector, (String)row.get("metadata"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<FaceVector> listFaces(long pageNum, long pageSize) {
        try {
            if (!this.isInit) {
                throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
            }
            if (pageNum < 1L || pageSize < 1L) {
                throw new IllegalArgumentException("pageNum\u548cpageSize\u5fc5\u987b\u5927\u4e8e0");
            }
            long offset = (pageNum - 1L) * pageSize;
            QueryParam queryParam = QueryParam.newBuilder().withCollectionName(this.collectionName).withOutFields(Arrays.asList("id", "vector", "metadata")).withOffset(Long.valueOf(offset)).withLimit(Long.valueOf(pageSize)).build();
            R response = this.serviceClient.query(queryParam);
            if (response.getStatus().intValue() != R.Status.Success.getCode()) {
                throw new VectorDBException("\u5206\u9875\u67e5\u8be2\u5931\u8d25: " + response.getMessage());
            }
            QueryResultsWrapper wrapper = new QueryResultsWrapper((QueryResults)response.getData());
            List records = wrapper.getRowRecords();
            if (records.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<FaceVector> result = new ArrayList<FaceVector>();
            for (QueryResultsWrapper.RowRecord row : records) {
                String id = (String)row.get("id");
                Object vectorObj = row.get("vector");
                float[] vector = null;
                if (vectorObj instanceof List) {
                    List vectorList = (List)vectorObj;
                    vector = new float[vectorList.size()];
                    for (int i = 0; i < vectorList.size(); ++i) {
                        vector[i] = ((Float)vectorList.get(i)).floatValue();
                    }
                }
                String metadata = (String)row.get("metadata");
                result.add(new FaceVector(id, vector, metadata));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void releaseCollection(String collectionName) {
        if (!this.isInit) {
            throw new VectorDBException("Milvus\u672a\u521d\u59cb\u5316\u5b8c\u6bd5");
        }
        R response = this.serviceClient.releaseCollection(ReleaseCollectionParam.newBuilder().withCollectionName(collectionName).build());
        if (response.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorDBException("Milvus releaseCollection\u5931\u8d25\uff0cmsg: " + response.getMessage());
        }
    }

    @Override
    public void loadFaceFeatures() {
        R loadResponse = this.serviceClient.loadCollection(LoadCollectionParam.newBuilder().withCollectionName(this.collectionName).build());
        if (loadResponse.getStatus().intValue() != R.Status.Success.getCode()) {
            throw new VectorDBException("Milvus \u52a0\u8f7d\u96c6\u5408\u5230\u5185\u5b58\u5931\u8d25\uff1a" + loadResponse.getMessage());
        }
        long count = this.count(this.collectionName);
        log.debug("\u52a0\u8f7d\u96c6\u5408\u5230\u5185\u5b58\u6210\u529f,\u4eba\u8138\u6570\u91cf\uff1a{}", (Object)count);
    }

    @Override
    public void releaseFaceFeatures() {
        this.releaseCollection(this.collectionName);
    }
}

