/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.ocr.config.DirectionModelConfig;
import cn.smartjavaai.ocr.config.OcrDetModelConfig;
import cn.smartjavaai.ocr.config.OcrRecModelConfig;
import cn.smartjavaai.ocr.enums.CommonDetModelEnum;
import cn.smartjavaai.ocr.enums.CommonRecModelEnum;
import cn.smartjavaai.ocr.enums.DirectionModelEnum;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.common.detect.OcrCommonDetModel;
import cn.smartjavaai.ocr.model.common.detect.OcrCommonDetModelImpl;
import cn.smartjavaai.ocr.model.common.direction.OcrDirectionModel;
import cn.smartjavaai.ocr.model.common.direction.PPOCRMobileV2ClsModel;
import cn.smartjavaai.ocr.model.common.recognize.OcrCommonRecModel;
import cn.smartjavaai.ocr.model.common.recognize.OcrCommonRecModelImpl;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrModelFactory {
    private static final Logger log = LoggerFactory.getLogger(OcrModelFactory.class);
    private static volatile OcrModelFactory instance;
    private static final ConcurrentHashMap<CommonDetModelEnum, OcrCommonDetModel> commonDetModelMap;
    private static final ConcurrentHashMap<CommonRecModelEnum, OcrCommonRecModel> commonRecModelMap;
    private static final ConcurrentHashMap<DirectionModelEnum, OcrDirectionModel> directionModelMap;
    private static final Map<CommonDetModelEnum, Class<? extends OcrCommonDetModel>> commonDetRegistry;
    private static final Map<CommonRecModelEnum, Class<? extends OcrCommonRecModel>> commonRecRegistry;
    private static final Map<DirectionModelEnum, Class<? extends OcrDirectionModel>> directionRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OcrModelFactory getInstance() {
        if (instance != null) return instance;
        Class<OcrModelFactory> clazz = OcrModelFactory.class;
        synchronized (OcrModelFactory.class) {
            if (instance != null) return instance;
            instance = new OcrModelFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerCommonDetModel(CommonDetModelEnum detModelEnum, Class<? extends OcrCommonDetModel> clazz) {
        commonDetRegistry.put(detModelEnum, clazz);
    }

    private static void registerCommonRecModel(CommonRecModelEnum recModelEnum, Class<? extends OcrCommonRecModel> clazz) {
        commonRecRegistry.put(recModelEnum, clazz);
    }

    private static void registerDirectionModel(DirectionModelEnum directionModelEnum, Class<? extends OcrDirectionModel> clazz) {
        directionRegistry.put(directionModelEnum, clazz);
    }

    public OcrCommonDetModel getDetModel(OcrDetModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return commonDetModelMap.computeIfAbsent(config.getModelEnum(), k -> this.createCommonDetModel(config));
    }

    public OcrCommonRecModel getRecModel(OcrRecModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getRecModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return commonRecModelMap.computeIfAbsent(config.getRecModelEnum(), k -> this.createCommonRecModel(config));
    }

    public OcrDirectionModel getDirectionModel(DirectionModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new OcrException("\u672a\u914d\u7f6eOCR\u6a21\u578b");
        }
        return directionModelMap.computeIfAbsent(config.getModelEnum(), k -> this.createDirectionModel(config));
    }

    private OcrCommonDetModel createCommonDetModel(OcrDetModelConfig config) {
        Class<? extends OcrCommonDetModel> clazz = commonDetRegistry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        OcrCommonDetModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    private OcrCommonRecModel createCommonRecModel(OcrRecModelConfig config) {
        Class<? extends OcrCommonRecModel> clazz = commonRecRegistry.get((Object)config.getRecModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        OcrCommonRecModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    private OcrDirectionModel createDirectionModel(DirectionModelConfig config) {
        Class<? extends OcrDirectionModel> clazz = directionRegistry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new OcrException("Unsupported model");
        }
        OcrDirectionModel model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OcrException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        commonDetModelMap = new ConcurrentHashMap();
        commonRecModelMap = new ConcurrentHashMap();
        directionModelMap = new ConcurrentHashMap();
        commonDetRegistry = new ConcurrentHashMap<CommonDetModelEnum, Class<? extends OcrCommonDetModel>>();
        commonRecRegistry = new ConcurrentHashMap<CommonRecModelEnum, Class<? extends OcrCommonRecModel>>();
        directionRegistry = new ConcurrentHashMap<DirectionModelEnum, Class<? extends OcrDirectionModel>>();
        OcrModelFactory.registerCommonDetModel(CommonDetModelEnum.PP_OCR_V5_SERVER_DET_MODEL, OcrCommonDetModelImpl.class);
        OcrModelFactory.registerCommonDetModel(CommonDetModelEnum.PP_OCR_V5_MOBILE_DET_MODEL, OcrCommonDetModelImpl.class);
        OcrModelFactory.registerCommonDetModel(CommonDetModelEnum.PP_OCR_V4_SERVER_DET_MODEL, OcrCommonDetModelImpl.class);
        OcrModelFactory.registerCommonDetModel(CommonDetModelEnum.PP_OCR_V4_MOBILE_DET_MODEL, OcrCommonDetModelImpl.class);
        OcrModelFactory.registerCommonRecModel(CommonRecModelEnum.PP_OCR_V5_SERVER_REC_MODEL, OcrCommonRecModelImpl.class);
        OcrModelFactory.registerCommonRecModel(CommonRecModelEnum.PP_OCR_V5_MOBILE_REC_MODEL, OcrCommonRecModelImpl.class);
        OcrModelFactory.registerCommonRecModel(CommonRecModelEnum.PP_OCR_V4_SERVER_REC_MODEL, OcrCommonRecModelImpl.class);
        OcrModelFactory.registerCommonRecModel(CommonRecModelEnum.PP_OCR_V4_MOBILE_REC_MODEL, OcrCommonRecModelImpl.class);
        OcrModelFactory.registerDirectionModel(DirectionModelEnum.CH_PPOCR_MOBILE_V2_CLS, PPOCRMobileV2ClsModel.class);
        OcrModelFactory.registerDirectionModel(DirectionModelEnum.PP_LCNET_X0_25, PPOCRMobileV2ClsModel.class);
        OcrModelFactory.registerDirectionModel(DirectionModelEnum.PP_LCNET_X1_0, PPOCRMobileV2ClsModel.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

