/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.detect;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.ocr.config.OcrDetModelConfig;
import cn.smartjavaai.ocr.entity.OcrBox;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.common.detect.OcrCommonDetModel;
import cn.smartjavaai.ocr.model.common.detect.criteria.OcrCommonDetCriterialFactory;
import cn.smartjavaai.ocr.utils.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrCommonDetModelImpl
implements OcrCommonDetModel {
    private static final Logger log = LoggerFactory.getLogger(OcrCommonDetModelImpl.class);
    private GenericObjectPool<Predictor<Image, NDList>> detPredictorPool;
    private ZooModel<Image, NDList> detectionModel;
    private OcrDetModelConfig config;

    @Override
    public void loadModel(OcrDetModelConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getDetModelPath())) {
            throw new OcrException("modelPath is null");
        }
        this.config = config;
        Criteria<Image, NDList> detCriteria = OcrCommonDetCriterialFactory.createCriteria(config);
        try {
            this.detectionModel = ModelZoo.loadModel(detCriteria);
            this.detPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.detectionModel));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.detPredictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.detectionModel.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new OcrException("\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public List<OcrBox> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new OcrException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        List<OcrBox> ocrBoxList = this.detect(img);
        ((Mat)img.getWrappedImage()).release();
        return ocrBoxList;
    }

    @Override
    public List<OcrBox> detect(Image image) {
        List<Image> imageList = Collections.singletonList(image);
        List<List<OcrBox>> result = this.batchDetectDJLImage(imageList);
        return result.get(0);
    }

    @Override
    public void detectAndDraw(String imagePath, String outputPath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new OcrException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            Image img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            List<OcrBox> boxList = this.detect(img);
            if (Objects.isNull(boxList) || boxList.isEmpty()) {
                throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
            }
            OcrUtils.drawRect((Mat)img.getWrappedImage(), boxList);
            Path output = Paths.get(outputPath, new String[0]);
            log.debug("Saving to {}", (Object)output.toAbsolutePath().toString());
            img.save(Files.newOutputStream(output, new OpenOption[0]), "png");
            ((Mat)img.getWrappedImage()).release();
        }
        catch (IOException e) {
            throw new OcrException(e);
        }
    }

    @Override
    public List<OcrBox> detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        List<OcrBox> ocrBoxList = this.detect(img);
        ((Mat)img.getWrappedImage()).release();
        return ocrBoxList;
    }

    @Override
    public List<OcrBox> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            return this.detect(image);
        }
        catch (IOException e) {
            throw new OcrException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public BufferedImage detectAndDraw(BufferedImage sourceImage) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)sourceImage));
        List<OcrBox> ocrBoxList = this.detect(img);
        if (Objects.isNull(ocrBoxList) || ocrBoxList.isEmpty()) {
            throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
        }
        OcrUtils.drawRect((Mat)img.getWrappedImage(), ocrBoxList);
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            img.save((OutputStream)outputStream, "png");
            byte[] imageBytes = outputStream.toByteArray();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(imageBytes));
            return bufferedImage;
        }
        catch (IOException e) {
            throw new OcrException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
        finally {
            if (img != null) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public List<List<OcrBox>> batchDetect(List<BufferedImage> imageList) {
        ArrayList<Image> djlImageList = new ArrayList<Image>(imageList.size());
        try {
            for (BufferedImage bufferedImage : imageList) {
                djlImageList.add(ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)bufferedImage)));
            }
            List<List<OcrBox>> list = this.batchDetectDJLImage(djlImageList);
            return list;
        }
        catch (Exception e) {
            throw new OcrException(e);
        }
        finally {
            djlImageList.forEach(image -> ((Mat)image.getWrappedImage()).release());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<List<OcrBox>> batchDetectDJLImage(List<Image> imageList) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public GenericObjectPool<Predictor<Image, NDList>> getPool() {
        return this.detPredictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.detPredictorPool != null) {
                this.detPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.detectionModel != null) {
                this.detectionModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }

    private static /* synthetic */ void lambda$batchDetectDJLImage$1(NDManager manager, NDList ndList) {
        ndList.attach(manager);
    }
}

