/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.direction.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import cn.smartjavaai.ocr.entity.DirectionInfo;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PpWordRotateTranslator
implements Translator<Image, DirectionInfo> {
    List<String> classes = Arrays.asList("No Rotate", "Rotate");
    private String batchifier;
    private int resizeHeight;
    private int resizeWidth;

    public PpWordRotateTranslator(Map<String, ?> arguments) {
        this.batchifier = arguments.containsKey("batchifier") ? arguments.get("batchifier").toString() : "padding";
        this.resizeWidth = arguments.containsKey("resizeWidth") ? (Integer)arguments.get("resizeWidth") : 192;
        this.resizeHeight = arguments.containsKey("resizeHeight") ? (Integer)arguments.get("resizeHeight") : 48;
    }

    public DirectionInfo processOutput(TranslatorContext ctx, NDList list) {
        NDArray prob = list.singletonOrThrow();
        float[] res = prob.toFloatArray();
        int maxIndex = 0;
        if (res[1] > res[0]) {
            maxIndex = 1;
        }
        return new DirectionInfo(this.classes.get(maxIndex), Double.valueOf(res[maxIndex]));
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager());
        int imgC = 3;
        int imgH = this.resizeHeight;
        int imgW = this.resizeWidth;
        NDArray array = ctx.getNDManager().zeros(new Shape(new long[]{imgC, imgH, imgW}));
        int h = input.getHeight();
        int w = input.getWidth();
        int resized_w = 0;
        float ratio = (float)w / (float)h;
        resized_w = Math.ceil((float)imgH * ratio) > (double)imgW ? imgW : (int)Math.ceil((float)imgH * ratio);
        img = NDImageUtils.resize((NDArray)img, (int)resized_w, (int)imgH);
        img = NDImageUtils.toTensor((NDArray)img).sub((Number)Float.valueOf(0.5f)).div((Number)Float.valueOf(0.5f));
        array.set(new NDIndex(":,:,0:" + resized_w, new Object[0]), img);
        return new NDList(new NDArray[]{array});
    }

    public Batchifier getBatchifier() {
        return Batchifier.fromString((String)this.batchifier);
    }
}

