/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.recognize;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.ndarray.NDManager;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import cn.hutool.core.img.ImgUtil;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.ocr.config.OcrRecModelConfig;
import cn.smartjavaai.ocr.config.OcrRecOptions;
import cn.smartjavaai.ocr.entity.OcrBox;
import cn.smartjavaai.ocr.entity.OcrInfo;
import cn.smartjavaai.ocr.entity.OcrItem;
import cn.smartjavaai.ocr.entity.RotatedBox;
import cn.smartjavaai.ocr.entity.RotatedBoxCompX;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.common.detect.OcrCommonDetModel;
import cn.smartjavaai.ocr.model.common.direction.OcrDirectionModel;
import cn.smartjavaai.ocr.model.common.recognize.OcrCommonRecModel;
import cn.smartjavaai.ocr.model.common.recognize.criteria.OcrCommonRecCriterialFactory;
import cn.smartjavaai.ocr.utils.OcrUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OcrCommonRecModelImpl
implements OcrCommonRecModel {
    private static final Logger log = LoggerFactory.getLogger(OcrCommonRecModelImpl.class);
    private GenericObjectPool<Predictor<Image, String>> recPredictorPool;
    private OcrRecModelConfig config;
    private ZooModel<Image, String> recognitionModel;
    private OcrDirectionModel directionModel;
    private OcrCommonDetModel textDetModel;

    @Override
    public void loadModel(OcrRecModelConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getRecModelPath())) {
            throw new OcrException("recModelPath is null");
        }
        this.config = config;
        this.directionModel = config.getDirectionModel();
        this.textDetModel = config.getTextDetModel();
        Criteria<Image, String> recCriteria = OcrCommonRecCriterialFactory.createCriteria(config);
        try {
            this.recognitionModel = ModelZoo.loadModel(recCriteria);
            this.recPredictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.recognitionModel));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.recPredictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.recognitionModel.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new OcrException("\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public OcrInfo recognize(String imagePath, OcrRecOptions options) {
        if (StringUtils.isBlank((CharSequence)this.config.getRecModelPath())) {
            throw new OcrException("recModelPath\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8bc6\u522b");
        }
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new OcrException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            OcrInfo ocrInfo = this.recognize(img, options);
            return ocrInfo;
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        finally {
            if (img != null) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public OcrInfo recognize(Image image, OcrRecOptions options) {
        List<OcrInfo> result = this.batchRecognizeDJLImage(Collections.singletonList(image), options);
        if (CollectionUtils.isEmpty(result)) {
            throw new OcrException("OCR\u8bc6\u522b\u7ed3\u679c\u4e3a\u7a7a");
        }
        return result.get(0);
    }

    private List<Image> batchAlign(List<OcrBox> boxList, Mat srcMat, NDManager manager) {
        ArrayList<Image> imageList = new ArrayList<Image>(boxList.size());
        for (int i = 0; i < boxList.size(); ++i) {
            Image subImg = OcrUtils.transformAndCrop(srcMat, boxList.get(i));
            if ((double)subImg.getHeight() * 1.0 / (double)subImg.getWidth() > 1.5) {
                subImg = OcrUtils.rotateImg(manager, subImg);
            }
            imageList.add(subImg);
        }
        return imageList;
    }

    private List<Image> batchAlignWithDirection(List<OcrItem> itemList, Mat srcMat, NDManager manager) {
        ArrayList<Image> imageList = new ArrayList<Image>(itemList.size());
        for (OcrItem ocrItem : itemList) {
            Image subImage = OcrUtils.transformAndCrop(srcMat, ocrItem.getOcrBox());
            subImage = OcrUtils.rotateImg(subImage, ocrItem.getAngle());
            imageList.add(subImage);
        }
        return imageList;
    }

    private OcrInfo postProcessOcrResult(List<RotatedBox> rotatedBoxes, OcrRecOptions ocrRecOptions) {
        if (!ocrRecOptions.isEnableLineSplit()) {
            return OcrUtils.convertRotatedBoxesToOcrItems(rotatedBoxes);
        }
        ArrayList<RotatedBox> initList = new ArrayList<RotatedBox>();
        for (RotatedBox result : rotatedBoxes) {
            initList.add(result);
        }
        Collections.sort(initList);
        ArrayList<ArrayList<RotatedBoxCompX>> lines = new ArrayList<ArrayList<RotatedBoxCompX>>();
        ArrayList<RotatedBoxCompX> line = new ArrayList<RotatedBoxCompX>();
        RotatedBoxCompX firstBox = new RotatedBoxCompX(((RotatedBox)initList.get(0)).getBox(), ((RotatedBox)initList.get(0)).getText());
        line.add(firstBox);
        lines.add(line);
        for (int i = 1; i < initList.size(); ++i) {
            RotatedBoxCompX tmpBox = new RotatedBoxCompX(((RotatedBox)initList.get(i)).getBox(), ((RotatedBox)initList.get(i)).getText());
            float y1 = firstBox.getBox().toFloatArray()[1];
            float y2 = tmpBox.getBox().toFloatArray()[1];
            float dis = Math.abs(y2 - y1);
            if (dis < 20.0f) {
                line.add(tmpBox);
                continue;
            }
            firstBox = tmpBox;
            Collections.sort(line);
            line = new ArrayList();
            line.add(firstBox);
            lines.add(line);
        }
        return OcrUtils.convertToOcrInfo(lines);
    }

    @Override
    public void recognizeAndDraw(String imagePath, String outputPath, int fontSize, OcrRecOptions options) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            throw new OcrException("\u56fe\u50cf\u6587\u4ef6\u4e0d\u5b58\u5728");
        }
        try {
            Image img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            OcrInfo ocrInfo = this.recognize(img, options);
            if (Objects.isNull(ocrInfo) || Objects.isNull(ocrInfo.getLineList()) || ocrInfo.getLineList().isEmpty()) {
                throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
            }
            Mat wrappedImage = (Mat)img.getWrappedImage();
            BufferedImage bufferedImage = OpenCVUtils.mat2Image((Mat)wrappedImage);
            OcrUtils.drawRectWithText(bufferedImage, ocrInfo, fontSize);
            ImageUtils.saveImage((BufferedImage)bufferedImage, (String)outputPath);
            wrappedImage.release();
        }
        catch (IOException e) {
            throw new OcrException(e);
        }
    }

    @Override
    public OcrInfo recognize(BufferedImage image, OcrRecOptions options) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
        OcrInfo ocrInfo = this.recognize(img, options);
        ((Mat)img.getWrappedImage()).release();
        return ocrInfo;
    }

    @Override
    public OcrInfo recognize(byte[] imageData, OcrRecOptions options) {
        if (Objects.isNull(imageData)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            return this.recognize(image, options);
        }
        catch (IOException e) {
            throw new OcrException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public BufferedImage recognizeAndDraw(BufferedImage sourceImage, int fontSize, OcrRecOptions options) {
        if (!ImageUtils.isImageValid((BufferedImage)sourceImage)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        Image img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)sourceImage));
        OcrInfo ocrInfo = this.recognize(img, options);
        if (Objects.isNull(ocrInfo) || Objects.isNull(ocrInfo.getLineList()) || ocrInfo.getLineList().isEmpty()) {
            throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
        }
        OcrUtils.drawRectWithText(sourceImage, ocrInfo, fontSize);
        return sourceImage;
    }

    @Override
    public String recognizeAndDrawToBase64(byte[] imageData, int fontSize, OcrRecOptions options) {
        if (Objects.isNull(imageData)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        OcrInfo ocrInfo = this.recognize(imageData, options);
        if (Objects.isNull(ocrInfo) || Objects.isNull(ocrInfo.getLineList()) || ocrInfo.getLineList().isEmpty()) {
            throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
        }
        try {
            BufferedImage sourceImage = ImageIO.read(new ByteArrayInputStream(imageData));
            OcrUtils.drawRectWithText(sourceImage, ocrInfo, fontSize);
            return ImgUtil.toBase64((java.awt.Image)sourceImage, (String)"png");
        }
        catch (IOException e) {
            throw new OcrException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
    }

    @Override
    public OcrInfo recognizeAndDraw(byte[] imageData, int fontSize, OcrRecOptions options) {
        if (Objects.isNull(imageData)) {
            throw new OcrException("\u56fe\u50cf\u65e0\u6548");
        }
        OcrInfo ocrInfo = this.recognize(imageData, options);
        if (Objects.isNull(ocrInfo) || Objects.isNull(ocrInfo.getLineList()) || ocrInfo.getLineList().isEmpty()) {
            throw new OcrException("\u672a\u68c0\u6d4b\u5230\u6587\u5b57");
        }
        try {
            BufferedImage sourceImage = ImageIO.read(new ByteArrayInputStream(imageData));
            OcrUtils.drawRectWithText(sourceImage, ocrInfo, fontSize);
            ocrInfo.setBase64Img(ImgUtil.toBase64((java.awt.Image)sourceImage, (String)"png"));
            return ocrInfo;
        }
        catch (IOException e) {
            throw new OcrException("\u5bfc\u51fa\u56fe\u7247\u5931\u8d25", e);
        }
    }

    @Override
    public List<OcrInfo> batchRecognize(List<BufferedImage> imageList, OcrRecOptions options) {
        ArrayList<Image> djlImageList = new ArrayList<Image>(imageList.size());
        try {
            for (BufferedImage bufferedImage : imageList) {
                djlImageList.add(ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)bufferedImage)));
            }
            List<OcrInfo> list = this.batchRecognizeDJLImage(djlImageList, options);
            return list;
        }
        catch (Exception e) {
            throw new OcrException(e);
        }
        finally {
            djlImageList.forEach(image -> ((Mat)image.getWrappedImage()).release());
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<OcrInfo> batchRecognizeDJLImage(List<Image> imageList, OcrRecOptions options) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> batchRecognize(List<Image> imageAlignList) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.recPredictorPool.borrowObject();
            List textList = predictor.batchPredict(imageAlignList);
            imageAlignList.forEach(subImg -> ((Mat)subImg.getWrappedImage()).release());
            List list = textList;
            return list;
        }
        catch (Exception e) {
            throw new OcrException("OCR\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.recPredictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public void setTextDetModel(OcrCommonDetModel detModel) {
        this.textDetModel = detModel;
    }

    @Override
    public OcrCommonDetModel getTextDetModel() {
        return this.textDetModel;
    }

    @Override
    public void setDirectionModel(OcrDirectionModel directionModel) {
        this.directionModel = directionModel;
    }

    @Override
    public OcrDirectionModel getDirectionModel() {
        return this.directionModel;
    }

    public GenericObjectPool<Predictor<Image, String>> getRecPredictorPool() {
        return this.recPredictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.recPredictorPool != null) {
                this.recPredictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.recognitionModel != null) {
                this.recognitionModel.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }

    private static /* synthetic */ Mat lambda$batchRecognizeDJLImage$1(Image image) {
        return (Mat)image.getWrappedImage();
    }
}

