/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.common.recognize.translator;

import ai.djl.Model;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.index.NDIndex;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PPOCRRecTranslator
implements Translator<Image, String> {
    private List<String> table;
    private final boolean use_space_char;
    private String batchifier;

    public PPOCRRecTranslator(Map<String, ?> arguments) {
        this.use_space_char = arguments.containsKey("use_space_char") ? Boolean.parseBoolean(arguments.get("use_space_char").toString()) : true;
        this.batchifier = arguments.containsKey("batchifier") ? arguments.get("batchifier").toString() : "padding";
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Model model = ctx.getModel();
        try (InputStream is = model.getArtifact("dict.txt").openStream();){
            this.table = Utils.readLines((InputStream)is, (boolean)true);
            this.table.add(0, "blank");
            if (this.use_space_char) {
                this.table.add(" ");
                this.table.add(" ");
            } else {
                this.table.add("");
                this.table.add("");
            }
        }
    }

    public String processOutput(TranslatorContext ctx, NDList list) throws IOException {
        StringBuilder sb = new StringBuilder();
        NDArray tokens = list.singletonOrThrow();
        long[] indices = tokens.argMax(1).toLongArray();
        boolean[] selection = new boolean[indices.length];
        Arrays.fill(selection, true);
        for (int i = 1; i < indices.length; ++i) {
            if (indices[i] != indices[i - 1]) continue;
            selection[i] = false;
        }
        int lastIdx = 0;
        for (int i = 0; i < indices.length; ++i) {
            if (!selection[i] || indices[i] <= 0L || i > 0 && indices[i] == (long)lastIdx) continue;
            sb.append(this.table.get((int)indices[i]));
        }
        return sb.toString();
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray img = input.toNDArray(ctx.getNDManager(), Image.Flag.COLOR);
        int imgC = 3;
        int imgH = 48;
        int imgW = 320;
        float max_wh_ratio = (float)imgW / (float)imgH;
        int h = input.getHeight();
        int w = input.getWidth();
        float wh_ratio = (float)w / (float)h;
        max_wh_ratio = Math.max(max_wh_ratio, wh_ratio);
        imgW = (int)((float)imgH * max_wh_ratio);
        int resized_w = Math.ceil((float)imgH * wh_ratio) > (double)imgW ? imgW : (int)Math.ceil((float)imgH * wh_ratio);
        NDArray resized_image = NDImageUtils.resize((NDArray)img, (int)resized_w, (int)imgH);
        resized_image = resized_image.transpose(new int[]{2, 0, 1}).toType(DataType.FLOAT32, false);
        resized_image.divi((Number)Float.valueOf(255.0f)).subi((Number)Float.valueOf(0.5f)).divi((Number)Float.valueOf(0.5f));
        NDArray padding_im = ctx.getNDManager().zeros(new Shape(new long[]{imgC, imgH, imgW}), DataType.FLOAT32);
        padding_im.set(new NDIndex(":,:,0:" + resized_w, new Object[0]), resized_image);
        padding_im = padding_im.flip(new int[]{0});
        return new NDList(new NDArray[]{padding_im});
    }

    public Batchifier getBatchifier() {
        return Batchifier.fromString((String)this.batchifier);
    }
}

