/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.plate.translator;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import cn.smartjavaai.ocr.entity.PlateResult;
import java.util.ArrayList;
import java.util.Iterator;

public class CRNNPlateRecTranslator
implements Translator<Image, PlateResult> {
    private static final String plateName = "#\u4eac\u6caa\u6d25\u6e1d\u5180\u664b\u8499\u8fbd\u5409\u9ed1\u82cf\u6d59\u7696\u95fd\u8d63\u9c81\u8c6b\u9102\u6e58\u7ca4\u6842\u743c\u5ddd\u8d35\u4e91\u85cf\u9655\u7518\u9752\u5b81\u65b0\u5b66\u8b66\u6e2f\u6fb3\u6302\u4f7f\u9886\u6c11\u822a\u53710123456789ABCDEFGHJKLMNPQRSTUVWXYZ\u9669\u54c1";
    private static final String[] plateColors = new String[]{"\u9ed1\u8272", "\u84dd\u8272", "\u7eff\u8272", "\u767d\u8272", "\u9ec4\u8272"};
    private static final float MEAN = 0.588f;
    private static final float STD = 0.193f;

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDManager manager = ctx.getNDManager();
        NDArray array = input.toNDArray(manager, Image.Flag.COLOR);
        array = NDImageUtils.resize((NDArray)array, (int)168, (int)48);
        array = array.toType(DataType.FLOAT32, false).div((Number)Float.valueOf(255.0f)).sub((Number)Float.valueOf(0.588f)).div((Number)Float.valueOf(0.193f));
        array = array.transpose(new int[]{2, 0, 1});
        array = array.expandDims(0);
        return new NDList(new NDArray[]{array});
    }

    public PlateResult processOutput(TranslatorContext ctx, NDList list) {
        NDArray plateOutput = (NDArray)list.get(0);
        NDArray colorOutput = (NDArray)list.get(1);
        int[] plateIdx = plateOutput.argMax(-1).toType(DataType.INT32, false).toIntArray();
        int colorIdx = colorOutput.argMax(1).toType(DataType.INT32, false).toIntArray()[0];
        String plateNo = this.decodePlate(plateIdx);
        String plateColor = plateColors[colorIdx];
        return new PlateResult(plateNo, plateColor);
    }

    private String decodePlate(int[] preds) {
        int pre = 0;
        ArrayList<Integer> newPreds = new ArrayList<Integer>();
        for (int idx : preds) {
            if (idx != 0 && idx != pre) {
                newPreds.add(idx);
            }
            pre = idx;
        }
        StringBuilder sb = new StringBuilder();
        Iterator iterator = newPreds.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            if (i < 0 || i >= plateName.length()) continue;
            sb.append(plateName.charAt(i));
        }
        return sb.toString();
    }

    public Batchifier getBatchifier() {
        return null;
    }
}

