/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.ocr.model.table;

import ai.djl.MalformedModelException;
import ai.djl.engine.Engine;
import ai.djl.inference.Predictor;
import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.ImageFactory;
import ai.djl.repository.zoo.Criteria;
import ai.djl.repository.zoo.ModelNotFoundException;
import ai.djl.repository.zoo.ModelZoo;
import ai.djl.repository.zoo.ZooModel;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.common.pool.PredictorFactory;
import cn.smartjavaai.common.utils.FileUtils;
import cn.smartjavaai.common.utils.ImageUtils;
import cn.smartjavaai.common.utils.OpenCVUtils;
import cn.smartjavaai.ocr.config.TableStructureConfig;
import cn.smartjavaai.ocr.entity.TableStructureResult;
import cn.smartjavaai.ocr.exception.OcrException;
import cn.smartjavaai.ocr.model.table.TableStructureModel;
import cn.smartjavaai.ocr.model.table.criteria.StructureCriteriaFactory;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Objects;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.opencv.core.Mat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonTableStructureModel
implements TableStructureModel {
    private static final Logger log = LoggerFactory.getLogger(CommonTableStructureModel.class);
    private ZooModel<Image, TableStructureResult> model;
    private GenericObjectPool<Predictor<Image, TableStructureResult>> predictorPool;

    @Override
    public void loadModel(TableStructureConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new OcrException("modelPath is null");
        }
        Criteria<Image, TableStructureResult> criteria = StructureCriteriaFactory.createCriteria(config);
        try {
            this.model = ModelZoo.loadModel(criteria);
            this.predictorPool = new GenericObjectPool((PooledObjectFactory)new PredictorFactory(this.model));
            int predictorPoolSize = config.getPredictorPoolSize();
            if (config.getPredictorPoolSize() <= 0) {
                predictorPoolSize = Runtime.getRuntime().availableProcessors();
            }
            this.predictorPool.setMaxTotal(predictorPoolSize);
            log.debug("\u5f53\u524d\u8bbe\u5907: " + this.model.getNDManager().getDevice());
            log.debug("\u5f53\u524d\u5f15\u64ce: " + Engine.getInstance().getEngineName());
            log.debug("\u6a21\u578b\u63a8\u7406\u5668\u7ebf\u7a0b\u6c60\u6700\u5927\u6570\u91cf: " + predictorPoolSize);
        }
        catch (MalformedModelException | ModelNotFoundException | IOException e) {
            throw new OcrException("\u8868\u683c\u7ed3\u6784\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25", e);
        }
    }

    @Override
    public R<TableStructureResult> detect(BufferedImage image) {
        if (!ImageUtils.isImageValid((BufferedImage)image)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromImage((Object)OpenCVUtils.image2Mat((BufferedImage)image));
            R<TableStructureResult> r = this.detect(img);
            return r;
        }
        catch (Exception e) {
            throw new OcrException(e);
        }
        finally {
            if (Objects.nonNull(img)) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<TableStructureResult> detect(String imagePath) {
        if (!FileUtils.isFileExists((String)imagePath)) {
            return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
        }
        Image img = null;
        try {
            img = ImageFactory.getInstance().fromFile(Paths.get(imagePath, new String[0]));
            R<TableStructureResult> r = this.detect(img);
            return r;
        }
        catch (IOException e) {
            throw new OcrException("\u65e0\u6548\u7684\u56fe\u7247", e);
        }
        finally {
            if (Objects.nonNull(img)) {
                ((Mat)img.getWrappedImage()).release();
            }
        }
    }

    @Override
    public R<TableStructureResult> detect(byte[] imageData) {
        if (Objects.isNull(imageData)) {
            return R.fail((R.Status)R.Status.INVALID_IMAGE);
        }
        try {
            BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
            return this.detect(image);
        }
        catch (IOException e) {
            throw new OcrException("\u9519\u8bef\u7684\u56fe\u50cf", e);
        }
    }

    @Override
    public R<TableStructureResult> detect(Image image) {
        Predictor predictor = null;
        try {
            predictor = (Predictor)this.predictorPool.borrowObject();
            TableStructureResult result = (TableStructureResult)predictor.predict((Object)image);
            R r = R.ok((Object)result);
            return r;
        }
        catch (Exception e) {
            throw new OcrException("OCR\u68c0\u6d4b\u9519\u8bef", e);
        }
        finally {
            if (predictor != null) {
                try {
                    this.predictorPool.returnObject((Object)predictor);
                }
                catch (Exception e) {
                    log.warn("\u5f52\u8fd8Predictor\u5931\u8d25", (Throwable)e);
                    try {
                        predictor.close();
                    }
                    catch (Exception ex) {
                        log.error("\u5173\u95edPredictor\u5931\u8d25", (Throwable)ex);
                    }
                }
            }
        }
    }

    @Override
    public GenericObjectPool<Predictor<Image, TableStructureResult>> getPool() {
        return this.predictorPool;
    }

    @Override
    public void close() throws Exception {
        try {
            if (this.predictorPool != null) {
                this.predictorPool.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed predictorPool \u5931\u8d25", (Throwable)e);
        }
        try {
            if (this.model != null) {
                this.model.close();
            }
        }
        catch (Exception e) {
            log.warn("\u5173\u95ed model \u5931\u8d25", (Throwable)e);
        }
    }
}

