/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.speech.asr.factory;

import cn.smartjavaai.common.config.Config;
import cn.smartjavaai.speech.asr.config.AsrModelConfig;
import cn.smartjavaai.speech.asr.enums.AsrModelEnum;
import cn.smartjavaai.speech.asr.exception.AsrException;
import cn.smartjavaai.speech.asr.model.SpeechRecognizer;
import cn.smartjavaai.speech.asr.model.VoskRecognizer;
import cn.smartjavaai.speech.asr.model.WhisperRecognizer;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpeechRecognizerFactory {
    private static final Logger log = LoggerFactory.getLogger(SpeechRecognizerFactory.class);
    private static volatile SpeechRecognizerFactory instance;
    private static final ConcurrentHashMap<AsrModelEnum, SpeechRecognizer> modelMap;
    private static final Map<AsrModelEnum, Class<? extends SpeechRecognizer>> registry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SpeechRecognizerFactory getInstance() {
        if (instance != null) return instance;
        Class<SpeechRecognizerFactory> clazz = SpeechRecognizerFactory.class;
        synchronized (SpeechRecognizerFactory.class) {
            if (instance != null) return instance;
            instance = new SpeechRecognizerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void registerModel(AsrModelEnum expressionModelEnum, Class<? extends SpeechRecognizer> clazz) {
        registry.put(expressionModelEnum, clazz);
    }

    public SpeechRecognizer getModel(AsrModelConfig config) {
        if (Objects.isNull((Object)config) || Objects.isNull((Object)config.getModelEnum())) {
            throw new AsrException("\u672a\u914d\u7f6e\u8bed\u97f3\u8bc6\u522b\u6a21\u578b\u679a\u4e3e");
        }
        return modelMap.computeIfAbsent(config.getModelEnum(), k -> this.createFaceModel(config));
    }

    private SpeechRecognizer createFaceModel(AsrModelConfig config) {
        Class<? extends SpeechRecognizer> clazz = registry.get((Object)config.getModelEnum());
        if (clazz == null) {
            throw new AsrException("Unsupported model");
        }
        SpeechRecognizer model = null;
        try {
            model = clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new AsrException(e);
        }
        model.loadModel(config);
        return model;
    }

    static {
        modelMap = new ConcurrentHashMap();
        registry = new ConcurrentHashMap<AsrModelEnum, Class<? extends SpeechRecognizer>>();
        SpeechRecognizerFactory.registerModel(AsrModelEnum.WHISPER, WhisperRecognizer.class);
        SpeechRecognizerFactory.registerModel(AsrModelEnum.VOSK, VoskRecognizer.class);
        log.debug("\u7f13\u5b58\u76ee\u5f55\uff1a{}", (Object)Config.getCachePath());
    }
}

