/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.speech.asr.model;

import ai.djl.util.JsonUtils;
import cn.smartjavaai.common.entity.Language;
import cn.smartjavaai.common.entity.R;
import cn.smartjavaai.speech.asr.config.AsrModelConfig;
import cn.smartjavaai.speech.asr.entity.AsrResult;
import cn.smartjavaai.speech.asr.entity.AsrSegment;
import cn.smartjavaai.speech.asr.entity.RecParams;
import cn.smartjavaai.speech.asr.entity.VoskParams;
import cn.smartjavaai.speech.asr.exception.AsrException;
import cn.smartjavaai.speech.asr.model.SpeechRecognizer;
import cn.smartjavaai.speech.utils.AudioUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vosk.LibVosk;
import org.vosk.LogLevel;
import org.vosk.Model;
import org.vosk.Recognizer;
import ws.schild.jave.EncoderException;

public class VoskRecognizer
implements SpeechRecognizer {
    private static final Logger log = LoggerFactory.getLogger(VoskRecognizer.class);
    private Model model;

    @Override
    public void loadModel(AsrModelConfig config) {
        if (StringUtils.isBlank((CharSequence)config.getModelPath())) {
            throw new AsrException("modelPath is null");
        }
        Path testModelPath = Paths.get(config.getModelPath(), new String[0]);
        if (!testModelPath.toFile().exists()) {
            throw new AsrException("Missing model file: " + testModelPath.toAbsolutePath());
        }
        try {
            if (Objects.nonNull(config.getLibPath())) {
                System.load(config.getLibPath().toAbsolutePath().toString());
            }
            this.model = new Model(config.getModelPath());
            LibVosk.setLogLevel((LogLevel)LogLevel.DEBUG);
            log.debug("Vosk init success");
        }
        catch (IOException e) {
            throw new AsrException(e);
        }
    }

    @Override
    public R<AsrResult> recognize(String audioPath) {
        return this.recognize(audioPath, (RecParams)new VoskParams());
    }

    @Override
    public R<AsrResult> recognize(byte[] audioData) {
        return this.recognize(audioData, (RecParams)new VoskParams());
    }

    @Override
    public R<AsrResult> recognize(InputStream audioStream) {
        return this.recognize(audioStream, (RecParams)new VoskParams());
    }

    private R<AsrResult> recognizeAudioStream(AudioInputStream ais, RecParams params) {
        R r;
        block14: {
            Recognizer recognizer = this.buildRecognizer(params, ais.getFormat().getSampleRate());
            try {
                AsrSegment finalSegment;
                AsrSegment segment;
                int nbytes;
                AudioFormat audioFormat = ais.getFormat();
                log.debug("sampleRate:{}", (Object)Float.valueOf(audioFormat.getSampleRate()));
                log.debug("channels:{}", (Object)audioFormat.getChannels());
                byte[] b = new byte[4096];
                ArrayList<AsrSegment> segments = new ArrayList<AsrSegment>();
                StringBuilder text = new StringBuilder();
                String temp = "";
                while ((nbytes = ais.read(b)) >= 0) {
                    if (recognizer.acceptWaveForm(b, nbytes)) {
                        String result = recognizer.getResult();
                        AsrSegment segment2 = this.parseSegment(result, params);
                        if (segment2 == null) continue;
                        segments.add(segment2);
                        text.append(segment2.getText());
                        continue;
                    }
                    temp = recognizer.getPartialResult();
                }
                if (StringUtils.isNotBlank((CharSequence)temp) && (segment = this.parsePartialSegment(temp, params)) != null) {
                    segments.add(segment);
                    text.append(segment.getText());
                }
                String finalText = recognizer.getFinalResult();
                if (StringUtils.isNotBlank((CharSequence)text.toString()) && StringUtils.isNotBlank((CharSequence)finalText) && (finalSegment = this.parseSegment(finalText, params)) != null && !text.toString().endsWith(finalSegment.getText())) {
                    AsrSegment alignSegment = VoskRecognizer.alignSegment((AsrSegment)segments.get(segments.size() - 1), finalSegment);
                    if (alignSegment != null) {
                        segments.set(segments.size() - 1, alignSegment);
                    } else {
                        segments.set(segments.size() - 1, finalSegment);
                    }
                }
                String result = segments.stream().map(AsrSegment::getText).collect(Collectors.joining("\n"));
                r = R.ok((Object)new AsrResult(result, segments));
                if (recognizer == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (recognizer != null) {
                        try {
                            recognizer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AsrException(e);
                }
            }
            recognizer.close();
        }
        return r;
    }

    private AsrSegment parseSegment(String segment, RecParams params) {
        JsonObject json = (JsonObject)JsonUtils.GSON.fromJson(segment, JsonObject.class);
        JsonArray resultArray = json.getAsJsonArray("result");
        if (Objects.isNull(resultArray) || resultArray.size() == 0) {
            return null;
        }
        double segmentStart = resultArray.get(0).getAsJsonObject().get("start").getAsDouble();
        double segmentEnd = resultArray.get(resultArray.size() - 1).getAsJsonObject().get("end").getAsDouble();
        long startMs = Math.round(segmentStart * 1000.0);
        long endMs = Math.round(segmentEnd * 1000.0);
        String text = json.get("text").getAsString();
        if (Objects.nonNull(params.getLanguage()) && params.getLanguage() == Language.ZH) {
            text = text.replace(" ", "");
        }
        return new AsrSegment(text, startMs, endMs);
    }

    private AsrSegment parsePartialSegment(String segment, RecParams params) {
        JsonObject json = (JsonObject)JsonUtils.GSON.fromJson(segment, JsonObject.class);
        JsonArray resultArray = json.getAsJsonArray("partial_result");
        if (Objects.isNull(resultArray) || resultArray.size() == 0) {
            return null;
        }
        double segmentStart = resultArray.get(0).getAsJsonObject().get("start").getAsDouble();
        double segmentEnd = resultArray.get(resultArray.size() - 1).getAsJsonObject().get("end").getAsDouble();
        long startMs = Math.round(segmentStart * 1000.0);
        long endMs = Math.round(segmentEnd * 1000.0);
        String text = json.get("partial").getAsString();
        if (Objects.nonNull(params.getLanguage()) && params.getLanguage() == Language.ZH) {
            text = text.replace(" ", "");
        }
        return new AsrSegment(text, startMs, endMs);
    }

    public static AsrSegment alignSegment(AsrSegment shortSeg, AsrSegment longSeg) {
        String shortText = shortSeg.getText();
        String longText = longSeg.getText();
        int index = longText.indexOf(shortText);
        if (index == -1) {
            return null;
        }
        String resultText = longText.substring(index);
        return new AsrSegment(resultText, shortSeg.getStartTime(), longSeg.getEndTime());
    }

    private Recognizer buildRecognizer(RecParams params, float sampleRate) throws IOException {
        if (!(params instanceof VoskParams)) {
            throw new AsrException("params is not VoskParams");
        }
        VoskParams voskParams = (VoskParams)params;
        Recognizer recognizer = new Recognizer(this.model, sampleRate);
        if (StringUtils.isNotBlank((CharSequence)voskParams.getGrammar())) {
            recognizer.setGrammar(voskParams.getGrammar());
        }
        recognizer.setWords(true);
        recognizer.setPartialWords(true);
        return recognizer;
    }

    @Override
    public R<AsrResult> recognize(String audioPath, RecParams params) {
        R<AsrResult> r;
        block9: {
            Path audioFilePath = Paths.get(audioPath, new String[0]);
            if (!audioFilePath.toFile().exists()) {
                return R.fail((R.Status)R.Status.FILE_NOT_FOUND);
            }
            InputStream is = Files.newInputStream(audioFilePath, new OpenOption[0]);
            try {
                r = this.recognize(is, params);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AsrException(e);
                }
            }
            is.close();
        }
        return r;
    }

    @Override
    public R<AsrResult> recognize(byte[] audioData, RecParams params) {
        R<AsrResult> r;
        ByteArrayInputStream is = new ByteArrayInputStream(audioData);
        try {
            r = this.recognize(is, params);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AsrException(e);
            }
        }
        ((InputStream)is).close();
        return r;
    }

    @Override
    public R<AsrResult> recognize(InputStream audioStream, RecParams params) {
        AudioInputStream ais = null;
        InputStream tryStream = null;
        BufferedInputStream conversionStream = null;
        boolean needConversion = false;
        try {
            byte[] allBytes = audioStream.readAllBytes();
            tryStream = new BufferedInputStream(new ByteArrayInputStream(allBytes));
            conversionStream = new BufferedInputStream(new ByteArrayInputStream(allBytes));
            ais = AudioSystem.getAudioInputStream(tryStream);
            R<AsrResult> r = this.recognizeAudioStream(ais, params);
            return r;
        }
        catch (UnsupportedAudioFileException e) {
            log.debug("Unsupported Audio file, Conversion to WAV is required");
            needConversion = true;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (tryStream != null) {
                try {
                    tryStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        File tempFile = null;
        if (needConversion) {
            try {
                tempFile = AudioUtils.audioFormatConversion(conversionStream, "wav");
            }
            catch (IOException | EncoderException e) {
                throw new AsrException(e);
            }
            try {
                R<AsrResult> r;
                BufferedInputStream fis = new BufferedInputStream(new FileInputStream(tempFile));
                try {
                    ais = AudioSystem.getAudioInputStream(fis);
                    r = this.recognizeAudioStream(ais, params);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((InputStream)fis).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException | UnsupportedAudioFileException e) {
                        throw new AsrException("\u97f3\u9891\u8f6c\u6362\u5f02\u5e38", e);
                    }
                }
                ((InputStream)fis).close();
                return r;
            }
            finally {
                if (tempFile != null && tempFile.exists()) {
                    tempFile.delete();
                }
                if (conversionStream != null) {
                    try {
                        ((InputStream)conversionStream).close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return R.fail((R.Status)R.Status.Unknown);
    }

    @Override
    public void close() throws Exception {
        if (this.model != null) {
            this.model.close();
        }
    }

    public Recognizer createAdvancedRecognizer(float sampleRate) {
        try {
            return new Recognizer(this.model, sampleRate);
        }
        catch (IOException e) {
            throw new AsrException(e);
        }
    }
}

