/*
 * Decompiled with CFR 0.152.
 */
package cn.smartjavaai.speech.utils;

import cn.hutool.core.lang.UUID;
import cn.smartjavaai.speech.asr.exception.AsrException;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import ws.schild.jave.Encoder;
import ws.schild.jave.EncoderException;
import ws.schild.jave.MultimediaObject;
import ws.schild.jave.encode.AudioAttributes;
import ws.schild.jave.encode.EncodingAttributes;
import ws.schild.jave.info.MultimediaInfo;

public class AudioUtils {
    public static byte[] read(AudioInputStream ais) throws IOException {
        int read;
        AudioFormat format = ais.getFormat();
        int frameSize = format.getFrameSize();
        if (frameSize == -1) {
            frameSize = 1;
        }
        int size = (int)ais.getFrameLength() * frameSize;
        if (ais.getFrameLength() == -1L || size <= 0) {
            int read2;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((read2 = ais.read(buf)) != -1) {
                baos.write(buf, 0, read2);
            }
            return baos.toByteArray();
        }
        byte[] ret = new byte[size];
        byte[] buf = new byte[1024];
        int offset = 0;
        while ((read = ais.read(buf)) != -1) {
            System.arraycopy(buf, 0, ret, offset, read);
            offset += read;
        }
        return ret;
    }

    public static byte[] getAudioFormatConversionBytes(String sourceFilePath, String targetFilePath, String format) {
        InputStream fis = null;
        ByteArrayOutputStream bos = null;
        byte[] bytes = null;
        try {
            File sourceFile = new File(sourceFilePath);
            if (sourceFile.isFile()) {
                int bytesRead;
                File targetFile = new File(targetFilePath);
                AudioUtils.audioFormatConversion(sourceFile, targetFile, format);
                fis = new FileInputStream(targetFile);
                bos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = fis.read(buffer)) != -1) {
                    bos.write(buffer, 0, bytesRead);
                }
                bytes = bos.toByteArray();
            }
        }
        catch (Exception e) {
            throw new AsrException("\u97f3\u9891\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage(), e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                throw new AsrException("\u97f3\u9891\u683c\u5f0f\u8f6c\u6362\u8d44\u6e90\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage(), e);
            }
        }
        return bytes;
    }

    public static InputStream getAudioFormatConversionIns(String sourceFilePath, String targetFilePath, String format) throws EncoderException, FileNotFoundException {
        File sourceFile = new File(sourceFilePath);
        if (sourceFile.isFile()) {
            File targetFile = new File(targetFilePath);
            AudioUtils.audioFormatConversion(sourceFile, targetFile, format);
            return new FileInputStream(targetFile);
        }
        return null;
    }

    public static void audioFormatConversion(File source, File target, String format) throws EncoderException {
        AudioAttributes audio = new AudioAttributes();
        switch (format) {
            case "wav": {
                audio.setCodec("pcm_s16le");
                break;
            }
            case "mp3": {
                audio.setCodec("libmp3lame");
                break;
            }
            case "amr": {
                audio.setCodec("libvo_amrwbenc");
                break;
            }
            default: {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u97f3\u9891\u683c\u5f0f\uff1a" + format);
            }
        }
        audio.setBitRate(Integer.valueOf(16000));
        audio.setChannels(Integer.valueOf(1));
        audio.setSamplingRate(Integer.valueOf(16000));
        EncodingAttributes attrs = new EncodingAttributes();
        attrs.setOutputFormat(format);
        attrs.setAudioAttributes(audio);
        Encoder encoder = new Encoder();
        encoder.encode(new MultimediaObject(source), target, attrs);
    }

    public static File audioFormatConversion(InputStream sourceStream, String format) throws EncoderException, IOException {
        File sourceFile = Files.createTempFile("source-", ".tmp", new FileAttribute[0]).toFile();
        try (FileOutputStream os = new FileOutputStream(sourceFile);){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = sourceStream.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
        File targetFile = Files.createTempFile("target-", "." + format, new FileAttribute[0]).toFile();
        AudioUtils.audioFormatConversion(sourceFile, targetFile, format);
        sourceFile.delete();
        return targetFile;
    }

    public static MultimediaInfo getAudioInfo(File source) throws EncoderException {
        MultimediaObject mo = new MultimediaObject(source);
        return mo.getInfo();
    }

    public static MultimediaInfo getAudioInfo(AudioInputStream ais) throws EncoderException, IOException {
        File tempFile = Files.createTempFile("audio_" + UUID.fastUUID().toString(), null, new FileAttribute[0]).toFile();
        tempFile.deleteOnExit();
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tempFile));){
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ais.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
        }
        return AudioUtils.getAudioInfo(tempFile);
    }
}

